<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>詢價單通知</title>
    <style>
        table {
            width: 100%;
            border-collapse: collapse;
        }
        th, td {
            padding: 8px;
            text-align: left;
            border: 1px solid #ddd;
        }
        th {
            background-color: #f4f4f4;
        }
    </style>
</head>
<body>
    <h2>詢價單通知</h2>
    <p>以下是您的新訂單詳細資訊：</p>
    <?php $__currentLoopData = collect($orderItems)->unique('order_id'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <p><strong>出貨模式：</strong> <?php echo e($order->shipping_mode); ?></p>
        <p><strong>寄運模式：</strong> <?php echo e($order->mailing_method); ?></p>
        <p><strong>寄送地點：</strong> <?php echo e($order->shipping_location); ?></p>
        <p><strong>是否附出貨單：</strong> <?php echo e($order->shipping ? '是' : '否'); ?></p>
        <?php if($order->technical_address): ?>
            <p><strong>住宅地址：</strong> <?php echo e($order->residential_address); ?></p>
        <?php endif; ?>
        <br>
        <?php if($order->mechanism): ?>
            <p><strong>診所名稱：</strong> <?php echo e($order->mechanism); ?></p>
        <?php endif; ?>
        <?php if($order->mechanism_doctor): ?>
            <p><strong>診所醫生：</strong> <?php echo e($order->mechanism_doctor); ?></p>
        <?php endif; ?>
        <?php if($order->mechanism_recipient): ?>
            <p><strong>診所聯絡人：</strong> <?php echo e($order->mechanism_recipient); ?></p>
        <?php endif; ?>
        <?php if($order->mechanism_recipient_phone): ?>
            <p><strong>診所電話：</strong> <?php echo e($order->mechanism_recipient_phone); ?></p>
        <?php endif; ?>
        <?php if($order->mechanism_recipient_address): ?>
            <p><strong>診所地址：</strong> <?php echo e($order->mechanism_recipient_address); ?></p>
        <?php endif; ?>
        <br>
        <p><strong>業務名稱：</strong> <?php echo e($order->sales_name); ?></p>
        <br>
        <?php if($order->technical_name): ?>
            <p><strong>技工所名稱：</strong> <?php echo e($order->technical_name); ?></p>
        <?php endif; ?>
        <?php if($order->technical_contact_person): ?>
            <p><strong>技工所聯絡人：</strong> <?php echo e($order->technical_contact_person); ?></p>
        <?php endif; ?>
        <?php if($order->technical_phone): ?>
            <p><strong>技工所電話：</strong> <?php echo e($order->technical_phone); ?></p>
        <?php endif; ?>
        <?php if($order->technical_address): ?>
            <p><strong>技工所地址：</strong> <?php echo e($order->technical_address); ?></p>
        <?php endif; ?>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    <table>
        <thead>
            <tr>
                <th>詢價編號</th>
                <th>產品名稱</th>
                <th>產品ID</th>
                <th>數量</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $orderItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($order->order_id); ?></td>
                    <td><?php echo e($order->product_name); ?></td>
                    <td><?php echo e($order->product_id); ?></td>
                    <td><?php echo e($order->quantity); ?></td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
    <h3>其他資訊</h3>
    <?php $__currentLoopData = collect($orderItems)->unique('order_id'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <p><strong>備註：</strong> <?php echo e($order->remark); ?></p>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    <p>謝謝您的詢價！</p>
</body>
</html>
<?php /**PATH /home/ilandtower/public_html/inquiry20250326/resources/views/mail/order.blade.php ENDPATH**/ ?>