<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            <?php echo e(__('儀表板')); ?><span class="px-2">訂單記錄</span>
        </h2>
     <?php $__env->endSlot(); ?>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8 overscroll-auto">
            <form action="<?php echo e(route('orders.search')); ?>" method="GET" class="mb-6 gap-4 md:flex justify-center items-center text-center">
                <?php echo csrf_field(); ?>
                <!-- 開始日期 -->
                <div class="mb-2">
                    <label for="start_date" class="block text-gray-700 font-semibold">開始日期</label>
                    <input type="date" id="start_date" name="start_date"
                        value="<?php echo e(request('start_date')); ?>"
                        class="px-4 py-2 border border-gray-300 rounded-md focus:ring-2 focus:ring-blue-500">
                </div>

                <!-- 結束日期 -->
                <div class="mb-2">
                    <label for="end_date" class="block text-gray-700 font-semibold">結束日期</label>
                    <input type="date" id="end_date" name="end_date"
                        value="<?php echo e(request('end_date')); ?>"
                        class="px-4 py-2 border border-gray-300 rounded-md focus:ring-2 focus:ring-blue-500">
                </div>

                <!-- 搜尋按鈕 -->
                <div class="mb-2">
                    <button type="submit" class="px-4 py-2 mx-10 bg-[#1b1b18] text-white rounded-lg hover:bg-[#FDFDFC] focus:outline-none focus:ring-2 focus:ring-blue-500">
                        搜尋
                    </button>
                </div>
            </form>

            <!-- 訂單結果表格 -->
            <div class="flex justify-center items-center">
                <table class="bg-white border border-gray-300 shadow-lg rounded-lg">
                    <thead class="bg-gray-100 border-b">
                        <tr>
                            <th class="px-6 py-3 text-left text-gray-700">詢價編號</th>
                            <th class="px-6 py-3 text-left text-gray-700 hidden sm:table-cell">日期</th>
                            <th class="px-6 py-3 text-left text-gray-700 hidden sm:table-cell">業務</th>
                            <th class="px-6 py-3 text-left text-gray-700  hidden sm:table-cell">收件人</th>
                            <th class="px-6 py-3 text-left text-gray-700 hidden">總金額</th>
                            <th class="px-6 py-3 text-left text-gray-700"></th>
                        </tr>
                    </thead>
                    <?php
                        // 先按 order_id 分組
                        $groupedOrders = $orderItems->groupBy('order_id');
                    ?>
                    <tbody>
                        <?php if($groupedOrders->isNotEmpty()): ?>
                            <?php $__currentLoopData = $groupedOrders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $orderId => $items): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr class="border-b hover:bg-gray-50">
                                    <td class="px-6 py-4"><?php echo e($orderId); ?></td>
                                    <td class="px-6 py-4 hidden sm:table-cell"><?php echo e($items->first()->created_at->format('Y-m-d')); ?></td>
                                    <td class="px-6 py-4 hidden sm:table-cell">
                                        <?php echo e($items->first()->sales_name ?? Auth::user()->currentTeam->name); ?>

                                    </td>
                                    <td class="px-6 py-4 hidden sm:table-cell text-center"><?php echo e($items->first()->mechanism ?? $items->first()->technical_name ?? Auth::user()->name); ?></td>
                                    <!-- 計算相同 order_id 的總金額 -->
                                    <?php
                                        $totalPrice = $items->sum(fn($item) => $item->price * $item->quantity);
                                    ?>
                                    <td class="px-6 py-4 text-green-600 font-semibold hidden">
                                        NT$ <?php echo e(number_format($totalPrice, 2)); ?>

                                    </td>

                                    <td>
                                        <form action="<?php echo e(route('order.detail' , $orderId)); ?>" method="POST">
                                            <?php echo csrf_field(); ?>
                                            <button class="px-4 py-2 mx-10 bg-[#1b1b18] text-white rounded-lg hover:bg-[#FDFDFC] focus:outline-none focus:ring-2 focus:ring-blue-500">
                                                明細
                                            </button>
                                        </form>  
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="6" class="px-6 py-4 text-center text-gray-500">查無資料</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            

            <?php if(session('message')): ?>
                <script>
                    alert("<?php echo e(session('message')); ?>");
                </script>
            <?php endif; ?>
        </div>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?><?php /**PATH /home/ilandtower/public_html/inquiry20250326/resources/views/order/show.blade.php ENDPATH**/ ?>