<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            <?php echo e(__('儀表板')); ?><span class="px-2">詢價清單</span>
        </h2>
     <?php $__env->endSlot(); ?>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <?php if($products->isNotEmpty()): ?>
                <div class="p-2 overflow-x-auto">
                    <table class="w-full table-auto border-collapse text-center">
                        <thead>
                            <tr class="bg-[#1b1b18] text-white text-left">
                                <th class="px-6 py-3 hidden sm:table-cell">規格</th>
                                <th class="px-6 py-3">產品 ID</th>
                                <th class="px-6 py-3 hidden sm:table-cell">品名</th>
                                <th class="px-6 py-3">數量</th>
                                <th class="px-6 py-3">操作</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white text-gray-800">
                            <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr class="border-b hover:bg-gray-100">
                                    <!-- 規格 -->
                                    <td class="px-6 py-4 whitespace-nowrap hidden sm:table-cell">
                                    <?php
                                        $spec = [];
                                        if (!empty($product->diameter)) $spec[] = '直徑：' . $product->diameter;
                                        if (!empty($product->length)) $spec[] = '長度：' . $product->length;
                                        if (!empty($product->high)) $spec[] = '高度：' . $product->high;
                                        if (!empty($product->cuff)) $spec[] = 'cuff：' . $product->cuff;
                                        if (!empty($product->angle)) $spec[] = 'angle：' . $product->angle . '°';
                                        if (!empty($product->type)) $spec[] = 'type：' . $product->type;
                                        if (!empty($product->post_h)) $spec[] = 'PostH：' . $product->post_h;
                                        if (!empty($product->post_h)) $spec[] = 'thirdCategory：' . $product->thirdCategory;
                                    ?>

                                    <?php if(empty($spec)): ?>
                                        <div>無規格</div>
                                    <?php else: ?>
                                        <?php echo e(implode('　', $spec)); ?>

                                    <?php endif; ?>

                                    </td>

                                    <!-- 產品 ID -->
                                    <td class="px-6 py-4"><?php echo e($product->product_id); ?></td>

                                    <!-- 品名 -->
                                    <td class="px-6 py-4 hidden sm:table-cell"><?php echo e($product->product_name); ?></td>

                                    <!-- 數量 -->
                                    <td class="px-6 py-4 text-center text-blue-600 font-bold">
                                        <form action="<?php echo e(route('cart.update', $product->id)); ?>" method="POST">
                                            <?php echo csrf_field(); ?>
                                            <input id="quantity-input-<?php echo e($product->id); ?>" 
                                                data-id="<?php echo e($product->id); ?>" 
                                                min="0" 
                                                value="<?php echo e($product->quantity); ?>" 
                                                type="number" 
                                                name="quantity-<?php echo e($product->id); ?>" 
                                                class="quantity-input w-16 md:w-40 text-center border rounded-md px-2 py-1">
                                            <input type="hidden" name="price-hidden-<?php echo e($product->id); ?>" value="<?php echo e($product->price); ?>">
                                    </td>

                                    <!-- 操作 -->
                                    <td class="px-6 py-4 space-x-2">
                                        <button type="submit" class="px-3 py-1 bg-green-600 text-white rounded hover:bg-green-700 hidden">修改</button>
                                        <input id="quantity-hidden-<?php echo e($product->id); ?>" 
                                            type="hidden" 
                                            name="quantity-hidden-<?php echo e($product->id); ?>" 
                                            value="<?php echo e($product->quantity); ?>">
                                        </form>
                                        <form action="<?php echo e(route('cart.remove', $product->id)); ?>" method="POST" class="inline-block">
                                            <?php echo csrf_field(); ?>
                                            <button type="submit" class="px-3 py-1 bg-red-600 text-white rounded hover:bg-red-700">移除</button>
                                        </form>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            <?php else: ?>
                <p class="text-gray-500 p-4 px-6">詢價車內沒有商品。</p>
            <?php endif; ?>

            
            <!--一次全部更新-->
            <div class="flex justify-center m-6">
                <form class="p-4" action="<?php echo e(route('update.all')); ?>" method="GET" onsubmit="return confirmSubmit()">
                    <?php echo csrf_field(); ?>
                    <?php if($products->isNotEmpty()): ?>
                        <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <input type="hidden" name="product_id[]" value="<?php echo e($product->product_id); ?>">
                            <input id="price-hidden1-<?php echo e($product->id); ?>" 
                                    type="hidden" 
                                    name="price[]" 
                                    value="<?php echo e($product->price); ?>">
                            <input id="quantity-hidden1-<?php echo e($product->id); ?>" 
                                    type="hidden" 
                                    name="quantity[]"
                                    value="<?php echo e($product->quantity); ?>">
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                    <?php if($products->isNotEmpty()): ?>
                    <button type="submit" class="px-4 py-2 mx-5 bg-green-600 text-white rounded-lg hover:bg-green-700 focus:outline-none focus:ring-2 focus:ring-black">
                        全部更新
                    </button>
                    <?php endif; ?>
                </form>
            </div>
            
            <!--總數量及價格-->
            <div class="flex justify-center mt-3">
                <h2 class="text-2xl font-bold text-gray-800 mb-6 px-6">商品總數量：
                    <?php if($products->isNotEmpty()): ?>
                        <span id="allQuantity">
                            <?php echo e($products->sum('quantity')); ?>  <!-- 計算數量總和 -->
                        </span>
                    <?php else: ?>
                        <span id="allQuantity">0</span>
                    <?php endif; ?>
                </h2>
                <h2 class="text-2xl font-bold text-gray-800 mb-6 px-6 hidden">商品總價：
                    <?php if($products->isNotEmpty()): ?>
                        <span id="allPrice">
                            <?php echo e($products->sum(fn($product) => $product->price * $product->quantity)); ?>  <!-- 計算價錢總和 -->
                        </span>
                    <?php else: ?>
                        <span id="allPrice">0</span>
                    <?php endif; ?>
                </h2>
            </div>

            <!--送出詢價-->
            <form action="<?php echo e(route('send.order')); ?>" method="GET" onsubmit="return confirmSubmit()">
                <?php echo csrf_field(); ?>
                <?php if($products->isNotEmpty()): ?>
                    <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <input type="hidden" name="brand_category[]" value="<?php echo e($product->brand_category); ?>">
                        <input type="hidden" name="brand_category_logo[]" value="<?php echo e($product->brand_category_logo); ?>">
                        <input type="hidden" name="series_category[]" value="<?php echo e($product->series_category); ?>">
                        <input type="hidden" name="product_categories[]" value="<?php echo e($product->product_categories); ?>">
                        <input type="hidden" name="system_category[]" value="<?php echo e($product->system_category); ?>">
                        <input type="hidden" name="product_id[]" value="<?php echo e($product->product_id); ?>">
                        <input type="hidden" name="product_name[]" value="<?php echo e($product->product_name); ?>">
                        <input type="hidden" name="price[]" value="<?php echo e($product->price); ?>">
                        <input type="hidden" name="diameter[]" value="<?php echo e($product->diameter); ?>">
                        <input type="hidden" name="length[]" value="<?php echo e($product->length); ?>">
                        <input type="hidden" name="high[]" value="<?php echo e($product->high); ?>">
                        <input type="hidden" name="cuff[]" value="<?php echo e($product->cuff); ?>">
                        <input type="hidden" name="angle[]" value="<?php echo e($product->angle); ?>">
                        <input type="hidden" name="type[]" value="<?php echo e($product->type); ?>">
                        <input type="hidden" name="post_h[]" value="<?php echo e($product->post_h); ?>">
                        <input type="hidden" name="thirdCategory[]" value="<?php echo e($product->thirdCategory); ?>">
                        <input type="hidden" name="image[]" value="<?php echo e($product->image); ?>">
                        <input type="hidden" id="quantity-hidden2-<?php echo e($product->id); ?>" name="quantity[]" value="<?php echo e($product->quantity); ?>">
                        <input type="hidden" name="series_category_logo[]" value="<?php echo e($product->series_category_logo); ?>">
                        <input type="hidden" name="product_categories_logo[]" value="<?php echo e($product->product_categories_logo); ?>">
                        <input type="hidden" name="system_category_logo[]" value="<?php echo e($product->system_category_logo); ?>">
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
                <?php if($products->isNotEmpty()): ?>
                    <div class="grid grid-cols-1 gap-4 px-4">
                        <div class="flex gap-4 items-center justify-center">
                            <p class="w-[10%]">出貨模式</p>
                            <select name="shipping_mode" class="w-[70%]" required>
                                <option value="一般出貨">一般出貨</option>
                                <option value="寄庫出貨">寄庫出貨</option>
                                <option value="儲值金出貨">儲值金出貨</option>
                                <option value="借換貨">借換貨</option>
                                <option value="借貨">借貨</option>
                            </select>
                        </div>
                        <div class="flex gap-4 items-center justify-center">
                            <p class="w-[10%]">寄運模式</p>
                            <select name="mailing_method" class="w-[70%]" required>
                                <option value="郵寄">郵寄</option>
                                <option value="郵寄快捷">郵寄快捷</option>
                                <option value="宅配">宅配</option>
                                <option value="業務親送">業務親送</option>
                                <option value="診所自取">診所自取</option>
                                <option value="診所叫拉拉取貨">診所叫拉拉取貨</option>
                            </select>
                        </div>
                        <div class="flex gap-4 items-center justify-center">
                            <p class="w-[10%]">寄送地點</p>
                            <select id="shipping_location" name="shipping_location" class="w-[70%]" required>
                                <option id="mechanism_option" value="診所">診所</option>
                                <option id="technical_option" value="技工所">技工所</option>
                                <option id="home_option" value="住宅">住宅</option>
                            </select>
                        </div>
                        <div class="flex gap-4 items-center justify-center">
                            <p class="w-[10%]">是否附出貨單</p>
                            <select name="shipping" class="w-[70%]" required>
                                <option value="true">是</option>
                                <option value="false">否</option>
                            </select>
                        </div>
                        <div class="flex gap-4 items-center justify-center hidden">
                            <p class="w-[10%]">是否附發票</p>
                            <select name="bill" class="w-[70%]" required>
                                <option value="true">是</option>
                                <option value="false">否</option>
                            </select>
                        </div>
                        <div id="home" class="flex gap-4 items-center justify-center hidden">
                            <label for="residential_address" class="w-[10%]">住宅地址</label>
                            <input id="home_input" class="w-[70%]" type="text" name="residential_address" value="" placeholder="住宅地址">
                        </div>
                        <div id="mechanism" class="flex gap-4 items-center justify-center">
                            <label for="mechanism" class="w-[10%]">診所名稱</label>
                            <input id="mechanism_input" class="w-[70%]" type="text" name="mechanism" value="<?php echo e(old('mechanism', $user->mechanism)); ?>" placeholder="診所名稱" required>  
                        </div>
                        <div id="mechanism_doctor" class="flex gap-4 items-center justify-center">
                            <label for="mechanism_doctor" class="w-[10%]">診所醫生</label>
                            <input id="mechanism_doctor_input" class="w-[70%]" type="text" name="mechanism_doctor" value="<?php echo e(old('mechanism_doctor', $user->mechanism_doctor)); ?>" placeholder="診所醫生" required>
                        </div>
                        <input type="hidden" name="doctor" value="" placeholder="負責醫生">
                        <input type="hidden" name="patient" value="" placeholder="病人名字">
                        <div id="mechanism_recipient" class="flex gap-4 items-center justify-center">
                            <label for="mechanism_recipient" class="w-[10%]">診所聯絡人</label>
                            <input id="mechanism_recipient_input" class="w-[70%]" type="text" name="mechanism_recipient" value="<?php echo e(old('mechanism_recipient', $user->mechanism_recipient)); ?>" placeholder="診所聯絡人" required>
                        </div>
                        <div id="mechanism_recipient_phone" class="flex gap-4 items-center justify-center">
                            <label for="mechanism_recipient_phone" class="w-[10%]">診所電話</label>
                            <input id="mechanism_recipient_phone_input" class="w-[70%]" type="text" name="mechanism_recipient_phone" value="<?php echo e(old('mechanism_recipient_phone', $user->mechanism_recipient_phone)); ?>" placeholder="診所電話" required>
                        </div>
                        <div id="mechanism_recipient_address" class="flex gap-4 items-center justify-center">
                            <label for="mechanism_recipient_address" class="w-[10%]">診所地址</label>
                            <input id="mechanism_recipient_address_input" class="w-[70%]" type="text" name="mechanism_recipient_address" value="<?php echo e(old('mechanism_recipient_address', $user->mechanism_recipient_address)); ?>" placeholder="診所地址" required>
                        </div>
                        <div class="flex gap-4 items-center justify-center">
                            <label for="sales_name" class="w-[10%]">業務名稱</label>
                            <input class="w-[70%]" type="text" name="sales_name" value="<?php echo e(old('sales_name', $user->sales_name)); ?>" placeholder="業務名稱">
                        </div>
                        <div id="technical_name" class="flex gap-4 items-center justify-center hidden">
                            <label for="technical_name" class="w-[10%]">技工所名稱</label>
                            <input id="technical_name_input" class="w-[70%]" type="text" name="technical_name" value="<?php echo e(old('technical_name')); ?>" placeholder="技工所名稱">
                        </div>
                        <div id="technical_contact_person" class="flex gap-4 items-center justify-center hidden">
                            <label for="technical_contact_person" class="w-[10%]">技工所聯絡人</label>
                            <input id="technical_contact_person_input" class="w-[70%]" type="text" name="technical_contact_person" value="<?php echo e(old('technical_contact_person')); ?>" placeholder="技工所聯絡人">
                        </div>
                        <div id="technical_phone" class="flex gap-4 items-center justify-center hidden">
                            <label for="technical_phone" class="w-[10%]">技工所電話</label>
                            <input id="technical_phone_input" class="w-[70%]" type="text" name="technical_phone" value="<?php echo e(old('technical_phone')); ?>" placeholder="技工所電話">
                        </div>
                        <div id="technical_address" class="flex gap-4 items-center justify-center hidden">
                            <label for="technical_address" class="w-[10%]">技工所地址</label>
                            <input id="technical_address_input" class="w-[70%]" type="text" name="technical_address" value="<?php echo e(old('technical_address')); ?>" placeholder="技工所地址">
                        </div>
                        <div class="flex gap-4 items-center justify-center">
                            <label for="remark" class="w-[10%]">其他備註</label>
                            <textarea class="w-[70%]" name="remark" rows="6" cols="40" placeholder="其他備註"></textarea>
                        </div>
                    </div>
                    <div class="flex justify-center mt-3">
                        <button type="submit" class="text-lg bg-green-600 text-white px-6 py-1 rounded-md hover:bg-green-700">
                            送出詢價
                        </button>
                    </div>
                <?php endif; ?>
            </form>
            
            <?php if(session('message')): ?>
                <script>
                    alert("<?php echo e(session('message')); ?>");
                </script>
            <?php endif; ?>
        </div>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>

<script>
    //同步更新隱藏price
    document.addEventListener("DOMContentLoaded", function () {
        document.querySelectorAll(".price-input").forEach(input => {
        input.addEventListener("input", function () {
            let productId = this.dataset.id; // 取得 data-id
            let hiddenInput = document.querySelector("#price-hidden-" + productId);
            let hiddenInput1 = document.querySelector("#price-hidden1-" + productId);


            if (hiddenInput) {
                hiddenInput.value = this.value; // 同步數值
                hiddenInput1.value = this.value; // 同步數值
                //console.log(`同步更新: #price-hidden-${productId} = ${this.value}`);
                }
            });
        });
    });

    //同步更新隱藏quantity
    document.addEventListener("DOMContentLoaded", function () {
        document.querySelectorAll(".quantity-input").forEach(input => {
        input.addEventListener("input", function () {
            let productId = this.dataset.id; // 取得 data-id
            let hiddenInput = document.querySelector("#quantity-hidden-" + productId);
            let hiddenInput1 = document.querySelector("#quantity-hidden1-" + productId);
            let hiddenInput2 = document.querySelector("#quantity-hidden2-" + productId);

            
            if (hiddenInput) {
                hiddenInput.value = this.value; // 同步數值
                hiddenInput1.value = this.value; // 同步數值
                hiddenInput2.value = this.value; // 同步數值

                //console.log(`同步更新: #quantity-hidden-${productId} = ${this.value}`);
                }
            });
        });
    });

    //再次確認使否更新數量及價錢
    function confirmSubmit() {
        return window.confirm("是否已確認總數量及總價格？");
    }

    //根據寄送地點選擇不同，顯示相應要填的資料_診所
    document.getElementById('shipping_location').addEventListener('change', function() {
        const selectedOption = this.options[this.selectedIndex];

        const userMechanism = "<?php echo e($user->mechanism); ?>";
        const mechanism = document.getElementById('mechanism');
        const mechanismInput = document.getElementById('mechanism_input');

        const userMechanismDoctor = "<?php echo e($user->mechanism_doctor); ?>";
        const mechanismDoctor = document.getElementById('mechanism_doctor');
        const mechanismDoctorInput = document.getElementById('mechanism_doctor_input');

        const userMechanismRecipient = "<?php echo e($user->mechanism_recipient); ?>";
        const mechanismRecipient = document.getElementById('mechanism_recipient');
        const mechanismRecipientInput = document.getElementById('mechanism_recipient_input');

        const userMechanismRecipientPhone = "<?php echo e($user->mechanism_recipient_phone); ?>";
        const mechanismRecipientPhone = document.getElementById('mechanism_recipient_phone');
        const mechanismRecipientPhoneInput = document.getElementById('mechanism_recipient_phone_input');

        const userMechanismRecipientAddress = "<?php echo e($user->mechanism_recipient_address); ?>";
        const mechanismRecipientAddress = document.getElementById('mechanism_recipient_address');
        const mechanismRecipientAddressInput = document.getElementById('mechanism_recipient_address_input');

        if (selectedOption.id === 'mechanism_option') {
            // 顯示區塊
            mechanism.classList.remove('hidden');
            mechanism.classList.add('block');
            mechanismDoctor.classList.remove('hidden');
            mechanismDoctor.classList.add('block');
            mechanismRecipient.classList.remove('hidden');
            mechanismRecipient.classList.add('block');
            mechanismRecipientPhone.classList.remove('hidden');
            mechanismRecipientPhone.classList.add('block');
            mechanismRecipientAddress.classList.remove('hidden');
            mechanismRecipientAddress.classList.add('block');

            // 設為必填
            mechanismInput.setAttribute('required', 'required');
            mechanismInput.value = userMechanism;

            mechanismDoctorInput.setAttribute('required', 'required');
            mechanismDoctorInput.value = userMechanismDoctor;

            mechanismRecipientInput.setAttribute('required', 'required');
            mechanismRecipientInput.value = userMechanismRecipient;

            mechanismRecipientPhoneInput.setAttribute('required', 'required');
            mechanismRecipientPhoneInput.value = userMechanismRecipientPhone;

            mechanismRecipientAddressInput.setAttribute('required', 'required');
            mechanismRecipientAddressInput.value = userMechanismRecipientAddress;

        } else {
            // 隱藏區塊
            mechanism.classList.remove('block');
            mechanism.classList.add('hidden');
            mechanismDoctor.classList.remove('block');
            mechanismDoctor.classList.add('hidden');
            mechanismRecipient.classList.remove('block');
            mechanismRecipient.classList.add('hidden');
            mechanismRecipientPhone.classList.remove('block');
            mechanismRecipientPhone.classList.add('hidden');
            mechanismRecipientAddress.classList.remove('block');
            mechanismRecipientAddress.classList.add('hidden');

            // 移除必填
            mechanismInput.removeAttribute('required');
            mechanismInput.value = "";

            mechanismDoctorInput.removeAttribute('required');
            mechanismDoctorInput.value = "";

            mechanismRecipientInput.removeAttribute('required');
            mechanismRecipientInput.value = "";

            mechanismRecipientPhoneInput.removeAttribute('required');
            mechanismRecipientPhoneInput.value = "";

            mechanismRecipientAddressInput.removeAttribute('required');
            mechanismRecipientAddressInput.value = "";
        }

    });

    //根據寄送地點選擇不同，顯示相應要填的資料_技工所
    document.getElementById('shipping_location').addEventListener('change', function() {
        const selectedOption = this.options[this.selectedIndex];

        const userTechnicalName = "<?php echo e($user->technical_name); ?>";
        const technicalName = document.getElementById('technical_name');
        const technicalNameInput = document.getElementById('technical_name_input');

        const userTechnicalContactPerson = "<?php echo e($user->technical_contact_person); ?>";
        const technicalContactPerson = document.getElementById('technical_contact_person');
        const technicalContactPersonInput = document.getElementById('technical_contact_person_input');

        const userTechnicalPhone = "<?php echo e($user->technical_phone); ?>";
        const technicalPhone = document.getElementById('technical_phone');
        const technicalPhoneInput = document.getElementById('technical_phone_input');

        const userTechnicalAddress = "<?php echo e($user->technical_address); ?>";
        const technicalAddress = document.getElementById('technical_address');
        const technicalAddressInput = document.getElementById('technical_address_input');

        if (selectedOption.id === 'technical_option') {
            // 顯示區塊
            technicalName.classList.remove('hidden');
            technicalName.classList.add('block');
            technicalContactPerson.classList.remove('hidden');
            technicalContactPerson.classList.add('block');
            technicalPhone.classList.remove('hidden');
            technicalPhone.classList.add('block');
            technicalAddress.classList.remove('hidden');
            technicalAddress.classList.add('block');

            // 設為必填
            technicalNameInput.setAttribute('required', 'required');
            technicalNameInput.value = userTechnicalName;

            technicalContactPersonInput.setAttribute('required', 'required');
            technicalContactPersonInput.value = userTechnicalContactPerson;

            technicalPhoneInput.setAttribute('required', 'required');
            technicalPhoneInput.value = userTechnicalPhone;

            technicalAddressInput.setAttribute('required', 'required');
            technicalAddressInput.value = userTechnicalAddress;
            
        } else {
            // 隱藏區塊
            technicalName.classList.remove('block');
            technicalName.classList.add('hidden');
            technicalContactPerson.classList.remove('block');
            technicalContactPerson.classList.add('hidden');
            technicalPhone.classList.remove('block');
            technicalPhone.classList.add('hidden');
            technicalAddress.classList.remove('block');
            technicalAddress.classList.add('hidden');

            // 移除必填
            technicalNameInput.removeAttribute('required');
            technicalNameInput.value = "";

            technicalContactPersonInput.removeAttribute('required');
            technicalContactPersonInput.value = "";

            technicalPhoneInput.removeAttribute('required');
            technicalPhoneInput.value = "";

            technicalAddressInput.removeAttribute('required');
            technicalAddressInput.value = "";
           
        }

    });

    //根據寄送地點選擇不同，顯示相應要填的資料_住宅
    document.getElementById('shipping_location').addEventListener('change', function() {
        const selectedOption = this.options[this.selectedIndex];

        const home = document.getElementById('home');
        const homeInput = document.getElementById('home_input');

       
        if (selectedOption.id === 'home_option') {
            // 顯示區塊
            home.classList.remove('hidden');
            home.classList.add('block');
            

            // 設為必填
            homeInput.setAttribute('required', 'required');
            
            
        } else {
            // 隱藏區塊
            home.classList.remove('block');
            home.classList.add('hidden');
            
            // 移除必填
            homeInput.removeAttribute('required');
            homeInput.value = "";
            
        }

    });
</script>
<?php /**PATH /Users/fve_macbookpro/Desktop/inquiry20250326/resources/views/cart/show.blade.php ENDPATH**/ ?>