<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Mail;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\BrandCategoryController;
use App\Http\Controllers\SeriesCategoryController;
use App\Http\Controllers\ProductCategoriesController;
use App\Http\Controllers\SystemCategoryController;
use App\Http\Controllers\SessionCartController;
use App\Http\Controllers\OrderController;
use App\Http\Controllers\SearchController;

//use App\Models\Product;
//use Illuminate\Http\Request;


Route::get('/', function () {
    return view('welcome');
});

/*
Route::middleware([
    'auth:sanctum',
    config('jetstream.auth_session'),
    'verified',
])->group(function () {
    Route::get('/dashboard', function () {
        return view('dashboard');
    })->name('dashboard');
});
*/

//搜尋home path 並修改home 分成user admin的方法
//https://www.youtube.com/watch?v=veBSb9JiKTA
Route::get('home',[AdminController::class, 'index'])->name('home');

Route::get('user/profile',[AdminController::class, 'profileShow'])->name('profile.show');

//http://127.0.0.1:8000/brand_category/MT
Route::get('/brand_category/{brand_category}', [BrandCategoryController::class, 'show'])->name('brand_category.show');

//http://127.0.0.1:8000/brand_category/MT/A+
Route::get('/brand_category/{brand_category}/{series_category}', [SeriesCategoryController::class, 'show'])->name('series_category.show');

//http://127.0.0.1:8000/brand_category/MT/ST/IMPLANT
Route::get('/brand_category/{brand_category}/{series_category}/{product_categories}', [ProductCategoriesController::class, 'show'])->name('product_categories.show');

//http://127.0.0.1:8000/brand_category/MT/A+/Abutment/Solid
Route::get('/brand_category/{brand_category}/{series_category}/{product_categories}/{system_category}', [SystemCategoryController::class, 'show'])->name('system_category.show');

//加入詢價車
Route::post('/cart/add', [SessionCartController::class, 'add'])->name('cart.add');

//顯示詢價清單
Route::get('/cart/show', [SessionCartController::class, 'show'])->name('cart.show');
//移除單一詢價商品
Route::post('/cart/remove/{id}', [SessionCartController::class, 'remove'])->name('cart.remove');
//更新單一詢價商品
Route::post('/cart/update/{id}', [SessionCartController::class, 'update'])->name('cart.update');
//更新所有產品價格數量
Route::get('/cart/update/all', [SessionCartController::class, 'updateAll'])->name('update.all');
//送出詢價單
Route::get('/send/order', [SessionCartController::class, 'sendOrder'])->name('send.order');

//顯示訂購紀錄
Route::get('/order/show', [OrderController::class, 'show'])->name('order.show');
//訂購紀錄搜尋
Route::get('/orders/search', [OrderController::class, 'search'])->name('orders.search');
//顯示訂單各項明細
Route::post('/order/detail/{order_id}', [OrderController::class, 'detail'])->name('order.detail');

//關鍵字搜尋
//http://127.0.0.1:8000/search?search=Z9999-12-1
/*
Route::get('/search/product', function (Request $request) {
    return Product::search($request->search)->get();
});
*/

Route::get('/search/product', [SearchController::class, 'search'])->name('product.search');









