<x-app-layout>
    <x-slot name="header">
        <div class="flex gap-4 items-center">
            @if ($product_categories == $system_category)
                <h2 class="font-semibold text-xl text-gray-800 leading-tight">
                    {{ __('儀表板') }}<span class="px-2">{{$brand_category}}/{{$series_category}}/{{$product_categories}} 規格選擇</span>
                </h2>
            @else
                <h2 class="font-semibold text-xl text-gray-800 leading-tight">
                    {{ __('儀表板') }}<span class="px-2">{{$brand_category}}/{{$series_category}}/{{$product_categories}}/{{$system_category}} 規格選擇</span>
                </h2>
            @endif

            @if ($product_categories == $system_category)
                <a href="{{ route('series_category.show', ['brand_category' => $brand_category, 'series_category' => $series_category]) }}" class="px-6 py-2 bg-gray-800 text-white rounded-md hover:bg-gray-700 focus:outline-none focus:ring-2 focus:ring-blue-500">
                    返回
                </a>
            @else
                <a href="{{ route('product_categories.show', ['brand_category' => $brand_category, 'series_category' => $series_category, 'product_categories' => $product_categories]) }}" class="px-6 py-2 bg-gray-800 text-white rounded-md hover:bg-gray-700 focus:outline-none focus:ring-2 focus:ring-blue-500">
                    返回
                </a>
            @endif
        </div>      
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="grid grid-cols-1 gap-6 mt-[100px] md:px-2 px-2 snap-x snap-mandatory"> 
                <!--產品卡片-->
                <table class="mx-auto mt-8 border border-gray-300 rounded-lg overflow-hidden">
                    <thead>
                        <tr class="bg-[#1b1b18] text-white text-sm">
                            <th class="px-6 py-3 text-left">系列類別</th>
                            <th class="px-6 py-3 text-left hidden sm:table-cell">圖片</th>
                            <th class="px-6 py-3 text-left hidden sm:table-cell">規格</th>
                            <th class="px-6 py-3 text-left hidden sm:table-cell">產品 ID</th>
                            <th class="px-6 py-3 text-left">品名</th>
                            <th class="px-6 py-3 text-left">詢價數量</th>
                            <th class="px-6 py-3 text-center">詢價選擇</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white text-sm">
                        @forelse ($products as $product)
                        <tr class="border-t border-gray-200">
                            <td class="text-center px-6 py-4 whitespace-nowrap">{{ $product['series_category'] }}</td>
                            <td class="text-center hidden sm:table-cell">
                                <img class="h-16 object-cover rounded-lg mx-auto" src="{{ asset('images/products/'.$product->image) }}" alt="{{ $product->image }}">
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap hidden sm:table-cell">
                                @php
                                    $spec = [];
                                    if (!empty($product->diameter)) $spec[] = '直徑：' . $product->diameter;
                                    if (!empty($product->length)) $spec[] = '長度：' . $product->length;
                                    if (!empty($product->high)) $spec[] = '高度：' . $product->high;
                                    if (!empty($product->cuff)) $spec[] = 'cuff：' . $product->cuff;
                                    if (!empty($product->angle)) $spec[] = 'angle：' . $product->angle . '°';
                                    if (!empty($product->type)) $spec[] = 'type：' . $product->type;
                                    if (!empty($product->post_h)) $spec[] = 'PostH：' . $product->post_h;
                                    if (!empty($product->thirdCategory)) $spec[] = 'thirdCategory：' . $product->thirdCategory;
                                @endphp

                                @if (empty($spec))
                                    <div>無規格</div>
                                @else
                                    {!! implode('<br>', $spec) !!}
                                @endif
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap hidden sm:table-cell">{{ $product['product_id'] }}</td>
                            <td class="px-6 py-4 whitespace-nowrap">{{ $product['product_name'] }}</td>
                            <td class="px-6 py-4 text-center text-blue-600 font-bold">
                                <input id="quantity-input-{{ $product->id }}" 
                                    data-id="{{ $product->id }}" 
                                    min="1" 
                                    value="1" 
                                    type="number" 
                                    name="quantity-{{$product->id}}" 
                                    class="quantity-input w-16 md:w-40 text-center border rounded-md px-2 py-1">
                            </td>
                            <td class="px-6 py-4 text-center">
                                <form action="{{ route('cart.add') }}" method="POST">
                                    @csrf
                                    <!-- 隱藏欄位 -->
                                    <input type="hidden" name="brand_category" value="{{ $product->brand_category }}">
                                    <input type="hidden" name="brand_category_logo" value="{{ $product->brand_category_logo }}">
                                    <input type="hidden" name="series_category" value="{{ $product->series_category }}">
                                    <input type="hidden" name="product_categories" value="{{ $product->product_categories }}">
                                    <input type="hidden" name="system_category" value="{{ $product->system_category }}">
                                    <input type="hidden" name="product_id" value="{{ $product->product_id }}">
                                    <input type="hidden" name="product_name" value="{{ $product->product_name }}">
                                    <input type="hidden" name="diameter" value="{{ $product->diameter }}">
                                    <input type="hidden" name="length" value="{{ $product->length }}">
                                    <input type="hidden" name="high" value="{{ $product->high }}">
                                    <input type="hidden" name="cuff" value="{{ $product->cuff }}">
                                    <input type="hidden" name="angle" value="{{ $product->angle }}">
                                    <input type="hidden" name="type" value="{{ $product->type }}">
                                    <input type="hidden" name="post_h" value="{{ $product->post_h }}">
                                    <input type="hidden" name="image" value="{{ $product->image }}">
                                    <input type="hidden" name="series_category_logo" value="{{ $product->series_category_logo }}">
                                    <input type="hidden" name="product_categories_logo" value="{{ $product->product_categories_logo }}">
                                    <input type="hidden" name="system_category_logo" value="{{ $product->system_category_logo }}">
                                    <input id="quantity-hidden-{{ $product->id }}" 
                                            type="hidden" 
                                            name="quantity" 
                                            value="1">
                                    <!-- 加入購物車按鈕 -->
                                    <div class="">
                                        <button type="submit" class="px-4 py-2 mx-10 bg-[#1b1b18] text-white rounded-lg hover:bg-[#FDFDFC] focus:outline-none focus:ring-2 focus:ring-blue-500">
                                            加入詢價
                                        </button>
                                    </div>
                                </form>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="4" class="text-center py-6 text-gray-500">無搜尋到任何產品</td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>

                @if(session('message'))
                    <script>
                        alert("{{ session('message') }}");
                    </script>
                @endif
            </div> 
        </div>
    </div>
</x-app-layout>

<script>
    //同步更新隱藏quantity
    document.addEventListener("DOMContentLoaded", function () {
    document.querySelectorAll(".quantity-input").forEach(input => {
        input.addEventListener("input", function () {
            let productId = this.dataset.id; // 取得 data-id
            let hiddenInput = document.querySelector("#quantity-hidden-" + productId);
            
            if (hiddenInput) {
                hiddenInput.value = this.value; // 同步數值

                //console.log(`同步更新: #quantity-hidden-${productId} = ${this.value}`);
                }
            });
        });
    });
</script>