<x-app-layout>
    <x-slot name="header">
        <div class="flex gap-4 items-center">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">
                {{ __('儀表板') }}<span class="px-2">{{$brand_category}}/{{$series_category}} 產品類別</span>
            </h2>
            <a href="{{ route('brand_category.show', ['brand_category' => $brand_category]) }}" class="px-6 py-2 bg-gray-800 text-white rounded-md hover:bg-gray-700 focus:outline-none focus:ring-2 focus:ring-blue-500 text-center">
                返回
            </a>
        </div>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <!--廠商列表-->
            <div class="grid grid-cols-1 gap-6 md:grid-cols-2 mt-[100px] md:px-2 px-2 snap-x snap-mandatory">
                <!--品牌系列-->
                @forelse ($products as $product)
                    <x-product-categories :product_categories="$product->product_categories"
                                          :logo="$product->product_categories_logo"
                                          :href="route('product_categories.show', ['brand_category' => $brand_category, 'series_category' => $series_category, 'product_categories' => $product->product_categories])"/>
                    
                 @empty
                 <div class="bg-white overflow-hidden shadow-xl sm:rounded-lg">
                    <div class="max-w-sm mx-auto bg-white rounded-lg shadow-lg overflow-hidden flex items-center justify-center p-4 hover:shadow-xl transition-shadow duration-300">
                        <div>
                            <h3 class="text-lg font-semibold text-gray-900 m-16">無搜尋到任何廠商</h3>
                        </div>
                    </div>
                </div>  
                @endforelse
            </div> 
             
        </div>
    </div>
</x-app-layout>
