<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('儀表板') }} <span class="px-2">品牌類別</span>
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <!--廠商列表-->
            <div class="grid grid-cols-1 gap-6 md:grid-cols-2 mt-[100px] md:px-2 px-2 snap-x snap-mandatory">
                <!--廠商logo及資訊-->
                @forelse ($products->unique('brand_category') as $product)
                    <x-brand-category :brand_category="($product->brand_category === 'T-PLUS') ? 'T-PLUS' : $product->brand_category"
                                      :remark="($product->brand_category === 'T-PLUS') ? 'Dental Implant' : NULL "
                                      :logo="$product->brand_category_logo" 
                                      :href="route('brand_category.show', $product->brand_category)" />
                 @empty
                 <div class="bg-white overflow-hidden shadow-xl sm:rounded-lg">
                    <div class="max-w-sm mx-auto bg-white rounded-lg shadow-lg overflow-hidden flex items-center justify-center p-4 hover:shadow-xl transition-shadow duration-300">
                        <div>
                            <h3 class="text-lg font-semibold text-gray-900 m-16">無搜尋到任何廠商</h3>
                        </div>
                    </div>
                </div>  
                @endforelse
            </div> 
             
        </div>
    </div>
</x-app-layout>
