<x-form-section submit="updateProfileInformation">
    <x-slot name="title">
        {{ __('個人資料資訊') }}
    </x-slot>

    <x-slot name="description">
        {{ __('更新您帳戶的個人資料資訊和電子郵件地址。') }}
    </x-slot>

    <x-slot name="form">
        <!-- Profile Photo -->
        @if (Laravel\Jetstream\Jetstream::managesProfilePhotos())
            <div x-data="{photoName: null, photoPreview: null}" class="col-span-6 sm:col-span-4">
                <!-- Profile Photo File Input -->
                <input type="file" id="photo" class="hidden"
                            wire:model.live="photo"
                            x-ref="photo"
                            x-on:change="
                                    photoName = $refs.photo.files[0].name;
                                    const reader = new FileReader();
                                    reader.onload = (e) => {
                                        photoPreview = e.target.result;
                                    };
                                    reader.readAsDataURL($refs.photo.files[0]);
                            " />

                <x-label for="photo" value="{{ __('Photo') }}" />

                <!-- Current Profile Photo -->
                <div class="mt-2" x-show="! photoPreview">
                    <img src="{{ $this->user->profile_photo_url }}" alt="{{ $this->user->name }}" class="rounded-full size-20 object-cover">
                </div>

                <!-- New Profile Photo Preview -->
                <div class="mt-2" x-show="photoPreview" style="display: none;">
                    <span class="block rounded-full size-20 bg-cover bg-no-repeat bg-center"
                          x-bind:style="'background-image: url(\'' + photoPreview + '\');'">
                    </span>
                </div>

                <x-secondary-button class="mt-2 me-2" type="button" x-on:click.prevent="$refs.photo.click()">
                    {{ __('Select A New Photo') }}
                </x-secondary-button>

                @if ($this->user->profile_photo_path)
                    <x-secondary-button type="button" class="mt-2" wire:click="deleteProfilePhoto">
                        {{ __('Remove Photo') }}
                    </x-secondary-button>
                @endif

                <x-input-error for="photo" class="mt-2" />
            </div>
        @endif

        <!-- LastName -->
        <div class="col-span-6 sm:col-span-4">
            <x-label for="last_name" value="{{ __('姓') }}" />
            <x-input id="last_name" type="text" class="mt-1 block w-full" wire:model="state.last_name" required autocomplete="last_name" />
            <x-input-error for="last_name" class="mt-2" />
        </div>

        <!-- FirstName -->
        <div class="col-span-6 sm:col-span-4">
            <x-label for="first_name" value="{{ __('名') }}" />
            <x-input id="first_name" type="text" class="mt-1 block w-full" wire:model="state.first_name" required autocomplete="first_name" />
            <x-input-error for="first_name" class="mt-2" />
        </div>

        <!-- Email -->
        <div class="col-span-6 sm:col-span-4">
            <x-label for="email" value="{{ __('電子郵件') }}" />
            <x-input id="email" type="email" class="mt-1 block w-full" wire:model="state.email" required autocomplete="username" />
            <x-input-error for="email" class="mt-2" />

            @if (Laravel\Fortify\Features::enabled(Laravel\Fortify\Features::emailVerification()) && ! $this->user->hasVerifiedEmail())
                <p class="text-sm mt-2">
                    {{ __('Your email address is unverified.') }}

                    <button type="button" class="underline text-sm text-gray-600 hover:text-gray-900 rounded-md focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500" wire:click.prevent="sendEmailVerification">
                        {{ __('Click here to re-send the verification email.') }}
                    </button>
                </p>

                @if ($this->verificationLinkSent)
                    <p class="mt-2 font-medium text-sm text-green-600">
                        {{ __('A new verification link has been sent to your email address.') }}
                    </p>
                @endif
            @endif
        </div>

        <!-- 診所名稱 -->
        <div class="col-span-6 sm:col-span-4">
            <x-label for="mechanism" value="{{ __('診所名稱') }}" />
            <x-input id="mechanism" type="text" class="mt-1 block w-full" wire:model="state.mechanism" autocomplete="no" />
            <x-input-error for="mechanism" class="mt-2" />
        </div>
        <!-- 診所醫師 -->
        <div class="col-span-6 sm:col-span-4">
            <x-label for="mechanism_doctor" value="{{ __('診所醫師') }}" />
            <x-input id="mechanism_doctor" type="text" class="mt-1 block w-full" wire:model="state.mechanism_doctor" autocomplete="no" />
            <x-input-error for="mechanism_doctor" class="mt-2" />
        </div>
        <!-- 聯絡人 -->
        <div class="col-span-6 sm:col-span-4">
            <x-label for="mechanism_recipient" value="{{ __('聯絡人') }}" />
            <x-input id="mechanism_recipient" type="text" class="mt-1 block w-full" wire:model="state.mechanism_recipient" autocomplete="no" />
            <x-input-error for="mechanism_recipient" class="mt-2" />
        </div>
        <!-- 診所電話 -->
        <div class="col-span-6 sm:col-span-4">
            <x-label for="mechanism_recipient_phone" value="{{ __('診所電話') }}" />
            <x-input id="mechanism_recipient_phone" type="text" class="mt-1 block w-full" wire:model="state.mechanism_recipient_phone" autocomplete="phone" />
            <x-input-error for="mechanism_recipient_phone" class="mt-2" />
        </div>
        <!-- 註冊人電話 -->
        <div class="col-span-6 sm:col-span-4">
            <x-label for="phone" value="{{ __('註冊人電話') }}" />
            <x-input id="phone" type="text" class="mt-1 block w-full" wire:model="state.phone" autocomplete="phone" />
            <x-input-error for="phone" class="mt-2" />
        </div>
        <!-- 診所地址 -->
        <div class="col-span-6 sm:col-span-4">
            <x-label for="mechanism_recipient_address" value="{{ __('診所地址') }}" />
            <x-input id="mechanism_recipient_address" type="text" class="mt-1 block w-full" wire:model="state.mechanism_recipient_address" autocomplete="addresss" />
            <x-input-error for="mechanism_recipient_address" class="mt-2" />
        </div>
        <!-- 負責業務人員 -->
        <div class="col-span-6 sm:col-span-4">
            <x-label for="sales_name" value="{{ __('負責業務人員') }}" />
            <x-input id="sales_name" type="text" class="mt-1 block w-full" wire:model="state.sales_name" autocomplete="name" />
            <x-input-error for="sales_name" class="mt-2" />
        </div>
        <!-- 技工所名稱 -->
        <div class="col-span-6 sm:col-span-4">
            <x-label for="technical_name" value="{{ __('技工所名稱') }}" />
            <x-input id="technical_name" type="text" class="mt-1 block w-full" wire:model="state.technical_name" autocomplete="no" />
            <x-input-error for="technical_name" class="mt-2" />
        </div>
        <!-- 技工所聯絡人 -->
        <div class="col-span-6 sm:col-span-4">
            <x-label for="technical_contact_person" value="{{ __('技工所聯絡人') }}" />
            <x-input id="technical_contact_person" type="text" class="mt-1 block w-full" wire:model="state.technical_contact_person" autocomplete="no" />
            <x-input-error for="technical_contact_person" class="mt-2" />
        </div>
        <!-- 技工所電話 -->
        <div class="col-span-6 sm:col-span-4">
            <x-label for="technical_phone" value="{{ __('技工所電話') }}" />
            <x-input id="technical_phone" type="text" class="mt-1 block w-full" wire:model="state.technical_phone" autocomplete="no" />
            <x-input-error for="technical_phone" class="mt-2" />
        </div>
        <!-- 技工所地址 -->
        <div class="col-span-6 sm:col-span-4">
            <x-label for="technical_address" value="{{ __('技工所地址') }}" />
            <x-input id="technical_address" type="text" class="mt-1 block w-full" wire:model="state.technical_address" autocomplete="no" />
            <x-input-error for="technical_address" class="mt-2" />
        </div>
    </x-slot>

    <x-slot name="actions">
        <x-action-message class="me-3" on="saved">
            {{ __('已儲存！') }}
        </x-action-message>

        <x-button wire:loading.attr="disabled" wire:target="photo">
            {{ __('儲存') }}
        </x-button>
    </x-slot>
</x-form-section>
