<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('儀表板') }}<span class="px-2">訂單明細</span>
        </h2>
    </x-slot>

    <div class="mx-auto p-6 bg-white rounded-lg shadow-lg flex flex-col justify-center">
        <div class="max-w-screen-xl mx-auto w-full">
            
            <h2 class="text-2xl font-semibold text-gray-800 mb-6">訂單詳細內容</h2>

            <div class="md:flex justify-between items-center mb-4">
                <div>
                    <div class="text-sm text-gray-500">詢價編號：{{$order_id}}</div>
                    @foreach ($orderItems->unique('order_id') as $orderItem)
                        <div class="text-sm text-gray-500">出貨模式：{{ $orderItem->shipping_mode }}</div>
                        <div class="text-sm text-gray-500">寄運模式：{{ $orderItem->mailing_method }}</div>
                        <div class="text-sm text-gray-500">寄送地點：{{ $orderItem->shipping_location }}</div>
                        <div class="text-sm text-gray-500">是否附出貨單：{{ $orderItem->shipping ? '是' : '否' }}</div>
                        <div class="text-sm text-gray-500 hidden">是否附發票：{{ $orderItem->bill ? '是' : '否' }}</div>
                        @if ($orderItem->residential_address)
                            <div class="text-sm text-gray-500">住宅地址：{{ $orderItem->residential_address }}</div>
                        @endif
                        @if ($orderItem->mechanism)
                            <div class="text-sm text-gray-500">診所名稱：{{ $orderItem->mechanism }}</div>
                        @endif
                        @if ($orderItem->mechanism_doctor)
                            <div class="text-sm text-gray-500">診所醫生：{{ $orderItem->mechanism_doctor }}</div>
                        @endif
                        @if ($orderItem->mechanism_recipient)
                            <div class="text-sm text-gray-500">診所聯絡人：{{ $orderItem->mechanism_recipient }}</div>
                        @endif
                    @endforeach
                </div>
                <div>
                    @foreach ($orderItems->unique('order_id') as $orderItem)
                        <div class="text-sm text-gray-500">訂單日期：{{ $orderItem->created_at->format('Y-m-d') }}</div>
                        @if ($orderItem->mechanism_recipient_phone)
                            <div class="text-sm text-gray-500">診所電話：{{ $orderItem->mechanism_recipient_phone }}</div>
                        @endif
                        @if ($orderItem->mechanism_recipient_address)
                            <div class="text-sm text-gray-500">診所地址：{{ $orderItem->mechanism_recipient_address }}</div>
                        @endif
                        <div class="text-sm text-gray-500">業務名稱：{{ $orderItem->sales_name }}</div>
                        @if ($orderItem->technical_name)
                            <div class="text-sm text-gray-500">技工所名稱：{{ $orderItem->technical_name }}</div>
                        @endif
                        @if ($orderItem->technical_contact_person)
                            <div class="text-sm text-gray-500">技工所聯絡人：{{ $orderItem->technical_contact_person }}</div>
                        @endif
                        @if ($orderItem->technical_phone)
                            <div class="text-sm text-gray-500">技工所電話：{{ $orderItem->technical_phone }}</div>
                        @endif
                        @if ($orderItem->technical_address)
                            <div class="text-sm text-gray-500">技工所地址：{{ $orderItem->technical_address }}</div>
                        @endif
                        <div class="text-sm text-gray-500">其他備註：{{ $orderItem->remark }}</div>
                    @endforeach
                </div>    
            </div>
            <div class="mb-6">
                <h3 class="text-lg font-medium text-gray-800 mb-2">詢價商品</h3>
                @foreach ($orderItems as $orderItem)
                <div class="space-y-4 w-full">
                    <!-- 商品 -->
                    <div class="grid grid-cols-4 gap-4 items-center border-b pb-3">
                        <!-- 圖片 -->
                        <div class="mt-2">
                            <img src="{{ asset('images/products/'. $orderItem->image) }}" alt="{{ $orderItem->image }}" class="w-24 object-cover">
                        </div>

                        <!-- 產品資訊 -->
                        <div class="text-gray-700">
                            {{$orderItem->brand_category}} /
                            {{$orderItem->series_category}} /
                            {{$orderItem->product_categories}} /
                            {{$orderItem->system_category}} /
                            {{$orderItem->product_name}}
                        </div>
                        <div>
                            商品ID： {{$orderItem->product_id}}
                        </div>

                        <!-- 數量與價格 -->
                        <div class="text-right gap-4">
                            <div class="text-gray-600">數量: {{$orderItem->quantity}}</div>
                            <div class="text-gray-800 font-semibold hidden">${{$orderItem->price}}</div>
                        </div>
                    </div>
                </div>
                @endforeach
            </div>

            <!-- 總計 -->
            <div class="flex justify-between items-center mb-4">
                <span class="text-gray-700">總計數量</span>
                @if ($orderItems->isNotEmpty())
                    <span class="text-gray-800 font-semibold">
                        {{ $orderItems->sum('quantity') }}  <!-- 計算數量總和 -->
                    </span>
                @else
                    <span class="text-gray-800 font-semibold">-</span>
                @endif  
            </div>

            <!-- 總金額 -->
            <div class="flex justify-between items-center text-lg font-semibold mb-6 hidden">
                <span>總金額</span>
                @if ($orderItems->isNotEmpty())
                    <span class="text-gray-900">
                        {{ $orderItems->sum(fn($orderItem) => $orderItem->price * $orderItem->quantity) }}  <!-- 計算價錢總和 -->
                    </span>
                @else
                    <span class="text-gray-900">-</span>
                @endif  
            </div>

            <!-- 付款狀態 -->
            <div class="mb-6">
                <h3 class="text-lg font-medium text-gray-800 mb-2">狀態</h3>
                <div class="text-green-600">-</div>
            </div>

            <!-- 按鈕 -->
            <div class="flex justify-between">
                <a href="{{ route('order.show') }}" class="px-6 py-2 bg-gray-800 text-white rounded-md hover:bg-gray-700 focus:outline-none focus:ring-2 focus:ring-blue-500">
                    返回
                </a>
            </div>
        </div>
    </div>
</x-app-layout>