<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>詢價單通知</title>
    <style>
        table {
            width: 100%;
            border-collapse: collapse;
        }
        th, td {
            padding: 8px;
            text-align: left;
            border: 1px solid #ddd;
        }
        th {
            background-color: #f4f4f4;
        }
    </style>
</head>
<body>
    <h2>詢價單通知</h2>
    <p>以下是您的新訂單詳細資訊：</p>
    @foreach(collect($orderItems)->unique('order_id') as $order)
        <p><strong>出貨模式：</strong> {{$order->shipping_mode}}</p>
        <p><strong>寄運模式：</strong> {{$order->mailing_method}}</p>
        <p><strong>寄送地點：</strong> {{$order->shipping_location}}</p>
        <p><strong>是否附出貨單：</strong> {{$order->shipping ? '是' : '否'}}</p>
        @if ($order->technical_address)
            <p><strong>住宅地址：</strong> {{$order->residential_address}}</p>
        @endif
        <br>
        @if ($order->mechanism)
            <p><strong>診所名稱：</strong> {{$order->mechanism}}</p>
        @endif
        @if ($order->mechanism_doctor)
            <p><strong>診所醫生：</strong> {{$order->mechanism_doctor}}</p>
        @endif
        @if ($order->mechanism_recipient)
            <p><strong>診所聯絡人：</strong> {{$order->mechanism_recipient}}</p>
        @endif
        @if ($order->mechanism_recipient_phone)
            <p><strong>診所電話：</strong> {{$order->mechanism_recipient_phone}}</p>
        @endif
        @if ($order->mechanism_recipient_address)
            <p><strong>診所地址：</strong> {{$order->mechanism_recipient_address}}</p>
        @endif
        <br>
        <p><strong>業務名稱：</strong> {{$order->sales_name}}</p>
        <br>
        @if ($order->technical_name)
            <p><strong>技工所名稱：</strong> {{$order->technical_name}}</p>
        @endif
        @if ($order->technical_contact_person)
            <p><strong>技工所聯絡人：</strong> {{$order->technical_contact_person}}</p>
        @endif
        @if ($order->technical_phone)
            <p><strong>技工所電話：</strong> {{$order->technical_phone}}</p>
        @endif
        @if ($order->technical_address)
            <p><strong>技工所地址：</strong> {{$order->technical_address}}</p>
        @endif
    @endforeach

    <table>
        <thead>
            <tr>
                <th>詢價編號</th>
                <th>產品名稱</th>
                <th>產品ID</th>
                <th>數量</th>
            </tr>
        </thead>
        <tbody>
            @foreach($orderItems as $order)
                <tr>
                    <td>{{ $order->order_id }}</td>
                    <td>{{ $order->product_name }}</td>
                    <td>{{ $order->product_id }}</td>
                    <td>{{ $order->quantity }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>
    <h3>其他資訊</h3>
    @foreach(collect($orderItems)->unique('order_id') as $order)
        <p><strong>備註：</strong> {{$order->remark}}</p>
    @endforeach

    <p>謝謝您的詢價！</p>
</body>
</html>
