@props(['brand_category', 'remark', 'logo', 'href' => '#'])

<a href="{{ $href }}">
    <div class="bg-white overflow-hidden shadow-xl sm:rounded-lg">
        <div class="max-w-sm mx-auto bg-white rounded-lg shadow-lg overflow-hidden flex items-center justify-center p-4 hover:shadow-xl transition-shadow duration-300">
            
            <!-- Logo -->
            <div class="shrink-0 flex items-center justify-center w-1/2">
                @if ($logo)
                    <img src="{{ asset('images/logos/' . $logo) }}" alt="品牌類別logo" class="w-16 h-16">
                @endif
            </div>

            <!-- 廠商名稱 -->
            <div class="text-center w-1/2 flex items-center justify-center">
                <div>
                    <h3 class="text-2xl font-semibold text-gray-900">{{ $brand_category }}</h3>
                    <h3 class="text-base font-semibold text-gray-900">{{ $remark }}</h3>
                </div>
            </div>
        </div>
    </div>
</a>
