<x-guest-layout>
    <x-authentication-card>
        <x-slot name="logo">
            <div class="mt-2 h-2"></div>
            <x-authentication-card-logo/>
        </x-slot>

        <x-validation-errors class="mb-4" />

        <form method="POST" action="{{ route('register') }}">
            @csrf

            <div>
                <x-label for="lastname" value="{{ __('姓*') }}" />
                <x-input id="lastname" class="block mt-1 w-full" type="text" name="lastname" :value="old('lastname')" required autofocus autocomplete="lastname" />
            </div>

            <div class="mt-4">
                <x-label for="firstname" value="{{ __('名*') }}" />
                <x-input id="firstname" class="block mt-1 w-full" type="text" name="firstname" :value="old('firstname')" required autofocus autocomplete="firstname" />
            </div>

            <div class="mt-4">
                <x-label for="email" value="{{ __('電子郵件*') }}" />
                <x-input id="email" class="block mt-1 w-full" type="email" name="email" :value="old('email')" required autocomplete="username" />
            </div>

            <div class="mt-4">
                <x-label for="password" value="{{ __('密碼*') }}" />
                <x-input id="password" class="block mt-1 w-full" type="password" name="password" required autocomplete="new-password" />
            </div>

            <div class="mt-4">
                <x-label for="password_confirmation" value="{{ __('再次確認密碼*') }}" />
                <x-input id="password_confirmation" class="block mt-1 w-full" type="password" name="password_confirmation" required autocomplete="new-password" />
            </div>

            <div class="mt-4">
                <x-label for="mechanism" value="{{ __('診所名稱') }}" />
                <x-input id="mechanism" class="block mt-1 w-full" type="text" name="mechanism" :value="old('mechanism')" autofocus autocomplete="no" />
            </div>

            <div class="mt-4">
                <x-label for="mechanism_doctor" value="{{ __('診所醫師') }}" />
                <x-input id="mechanism_doctor" class="block mt-1 w-full" type="text" name="mechanism_doctor" :value="old('mechanism_doctor')" autofocus autocomplete="no" />
            </div>

            <div class="mt-4">
                <x-label for="mechanism_recipient" value="{{ __('聯絡人') }}" />
                <x-input id="mechanism_recipient" class="block mt-1 w-full" type="text" name="mechanism_recipient" :value="old('mechanism_recipient')" autofocus autocomplete="no" />
            </div>

            <div class="mt-4">
                <x-label for="mechanism_recipient_phone" value="{{ __('診所電話') }}" />
                <x-input id="mechanism_recipient_phone" class="block mt-1 w-full" type="text" name="mechanism_recipient_phone" :value="old('mechanism_recipient_phone')" autofocus autocomplete="phone" />
            </div>

            <div class="mt-4">
                <x-label for="phone" value="{{ __('註冊人電話') }}" />
                <x-input id="phone" class="block mt-1 w-full" type="text" name="phone" :value="old('phone')" autofocus autocomplete="phone" />
            </div>

            <div class="mt-4">
                <x-label for="mechanism_recipient_address" value="{{ __('診所地址') }}" />
                <x-input id="mechanism_recipient_address" class="block mt-1 w-full" type="text" name="mechanism_recipient_address" :value="old('mechanism_recipient_address')" autofocus autocomplete="address" />
            </div>

            <div class="mt-4">
                <x-label for="sales_name" value="{{ __('負責業務人員') }}" />
                <x-input id="sales_name" class="block mt-1 w-full" type="text" name="sales_name" :value="old('sales_name')" autofocus autocomplete="name" />
            </div>

            <div class="mt-4">
                <x-label for="technical_name" value="{{ __('技工所名稱') }}" />
                <x-input id="technical_name" class="block mt-1 w-full" type="text" name="technical_name" :value="old('technical_name')" autofocus autocomplete="no" />
            </div>

            <div class="mt-4">
                <x-label for="technical_contact_person" value="{{ __('技工所聯絡人') }}" />
                <x-input id="technical_contact_person" class="block mt-1 w-full" type="text" name="technical_contact_person" :value="old('technical_contact_person')" autofocus autocomplete="name" />
            </div>

            <div class="mt-4">
                <x-label for="technical_phone" value="{{ __('技工所電話') }}" />
                <x-input id="technical_phone" class="block mt-1 w-full" type="text" name="technical_phone" :value="old('technical_phone')" autofocus autocomplete="phone" />
            </div>

            <div class="mt-4">
                <x-label for="technical_address" value="{{ __('技工所地址') }}" />
                <x-input id="technical_address" class="block mt-1 w-full" type="text" name="technical_address" :value="old('technical_address')" autofocus autocomplete="address" />
            </div>

            @if (Laravel\Jetstream\Jetstream::hasTermsAndPrivacyPolicyFeature())
                <div class="mt-4">
                    <x-label for="terms">
                        <div class="flex items-center">
                            <x-checkbox name="terms" id="terms" required />

                            <div class="ms-2">
                                {!! __('我同意 :terms_of_service 和 :privacy_policy', [
                                        'terms_of_service' => '<a target="_blank" href="'.route('terms.show').'" class="underline text-sm text-gray-600 hover:text-gray-900 rounded-md focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">'.__('服務條款').'</a>',
                                        'privacy_policy' => '<a target="_blank" href="'.route('policy.show').'" class="underline text-sm text-gray-600 hover:text-gray-900 rounded-md focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">'.__('隱私條款').'</a>',
                                ]) !!}
                            </div>
                        </div>
                    </x-label>
                </div>
            @endif

            <div class="flex items-center justify-end mt-4">
                <a class="underline text-sm text-gray-600 hover:text-gray-900 rounded-md focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500" href="{{ route('login') }}">
                    {{ __('已經註冊？') }}
                </a>

                <x-button class="ms-4">
                    {{ __('註冊') }}
                </x-button>
            </div>
        </form>
    </x-authentication-card>
</x-guest-layout>
