<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('products', function (Blueprint $table) {
            $table->id();
            $table->string('brand_category');
            $table->string('brand_category_logo')->nullable(); 
            $table->string('series_category');
            $table->string('product_categories');
            $table->string('system_category');
            $table->string('product_id');
            $table->string('product_name');
            $table->string('price')->nullable();
            $table->string('diameter')->nullable();
            $table->string('length')->nullable();
            $table->string('high')->nullable();
            $table->string('cuff')->nullable();
            $table->string('angle')->nullable();
            $table->string('type')->nullable();
            $table->string('post_h')->nullable();
            $table->string('image')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('products');
    }
};
