<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Validator;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        Validator::replacer('min', function ($message, $attribute, $rule, $parameters) {
            if ($attribute === 'password') {
                return '密碼長度不足！請至少輸入 ' . $parameters[0] . ' 個字元。';
            }
            return $message;
        });

        // 自訂密碼確認錯誤訊息
        Validator::replacer('confirmed', function ($message, $attribute, $rule, $parameters) {
            if ($attribute === 'password') {
                return '密碼與確認密碼不一致，請重新輸入！';
            }
            return $message;
        });
    }
}
