<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class OrderMail extends Mailable
{
    use Queueable, SerializesModels;

    public $orderItems;// 儲存訂單項目資料
    public $order_id; // ← 這一行很重要

    /**
     * Create a new message instance.
     */
    public function __construct($orderItems, $order_id)
    {
        $this->orderItems = $orderItems; // 儲存訂單項目資料
        $this->order_id = $order_id; // ← 儲存傳入的 order_id
    }

    /**
     * Get the message envelope.
     */
    public function envelope(): Envelope
    {
        return new Envelope(
            subject: '詢價系統詢價 詢價編號：' . $this->order_id,
        );
    }

    /**
     * Get the message content definition.
     */
    public function content(): Content
    {
        return new Content(
            view: 'mail.order', // 指定郵件的視圖
            with: [
                'orderItems' => $this->orderItems, // 將訂單項目資料傳遞給視圖
            ]
        );
    }

    /**
     * Get the attachments for the message.
     *
     * @return array<int, \Illuminate\Mail\Mailables\Attachment>
     */
    public function attachments(): array
    {
        return [];
    }
}
