<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Product;

class SystemCategoryController extends Controller
{
    public function show($brand_category, $series_category, $product_categories, $system_category)
    {
        $products =  Product::where('brand_category', $brand_category)
                    ->where('series_category', $series_category)
                    ->where('product_categories', $product_categories)
                    ->where('system_category', $system_category)->get();

        // 如果沒有產品類別，則返回 404 頁面
        if ($products->isEmpty()) {
            abort(404, '找不到您選擇的產品類別');
        }

        return view('system_category.show', compact('brand_category', 'series_category', 'product_categories', 'system_category','products'));
    }
}
