<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\SessionCart;
use App\Models\Order;
use App\Mail\OrderMail;
use Illuminate\Support\Facades\Mail;
use App\Models\User;

use Illuminate\Support\Facades\Auth;
//取出當日日期
use Carbon\Carbon;


class SessionCartController extends Controller
{
    //加入詢價清單
    public function add(Request $request)
    {
        // 檢查用戶購物車中是否已經有相同商品
        $existingItem = SessionCart::where('user_id', Auth::id())
        ->where('product_id', $request->input('product_id'))
        ->first();

        // 如果已經有該商品，返回訊息
        if ($existingItem) {
        return redirect()->back()->with('message', '此商品已經放入詢價車');
        }

        
        // 使用模型寫入資料
        $SessionCart = new SessionCart();
        $SessionCart->user_id = Auth::id();
        $SessionCart->brand_category = $request->input('brand_category');
        $SessionCart->brand_category_logo = $request->input('brand_category_logo');
        $SessionCart->series_category = $request->input('series_category');
        $SessionCart->product_categories = $request->input('product_categories');
        $SessionCart->system_category = $request->input('system_category');
        $SessionCart->product_id = $request->input('product_id');
        $SessionCart->product_name = $request->input('product_name');
        $SessionCart->diameter = $request->input('diameter');
        $SessionCart->length = $request->input('length');
        $SessionCart->high = $request->input('high');
        $SessionCart->cuff = $request->input('cuff');
        $SessionCart->angle = $request->input('angle');
        $SessionCart->type = $request->input('type');
        $SessionCart->post_h = $request->input('post_h');
        $SessionCart->thirdCategory = $request->input('thirdCategory');
        $SessionCart->image = $request->input('image');
        $SessionCart->series_category_logo = $request->input('series_category_logo');
        $SessionCart->product_categories_logo = $request->input('product_categories_logo');
        $SessionCart->system_category_logo = $request->input('system_category_logo');

    
        $SessionCart->price = '0';
        //$SessionCart->quantity = '1';
        $SessionCart->quantity = $request->input('quantity');

        $SessionCart->save();

         // 返回到原頁面，並附加一個成功訊息
        return back()->with('message', '成功將此產品放入詢價車！');
    }

    //顯示詢價清單
    public function show()
    {
        // 取得該廠商的所有產品
        $products = SessionCart::where('user_id', Auth::id())->get();
        $user = Auth::user(); // 取得目前登入的使用者

        // 回傳詢價車畫面
        return view('cart.show', compact('products','user'));
    }

    //移除單一詢價商品
    public function remove($id)
    {
         // 根據 ID 查找並刪除對應的購物車項目
        $cartItem = SessionCart::find($id);

        // 確保該項目存在並且屬於當前用戶
        if ($cartItem) {
            $cartItem->delete();  // 刪除該項目
            return redirect()->route('cart.show')->with('message', '商品已成功移除');
        } else {
            return redirect()->route('cart.show')->with('message', '無法找到該商品或您無權刪除它');
        }
    }

    //更新單一詢價商品數量及價錢
    public function update(Request $request, $id)
    {
        // 取得當前使用者的購物車項目
        $cartItem = SessionCart::where('id', $id)
                    ->where('user_id', Auth::id())
                    ->first();  // 使用 first() 獲取單一模型實例
        // 檢查購物車項目是否存在
        if ($cartItem) {
            // 更新價格和數量
            $cartItem->price = $request->input("price-hidden-{$id}"); 
            $cartItem->quantity = $request->input("quantity-hidden-{$id}");
            // 儲存更新
            $cartItem->save();

            // 回傳成功訊息並重定向
            return redirect()->route('cart.show')->with('message', '詢價車商品已成功更新');
        } else {
            // 如果找不到購物車項目
            return redirect()->route('cart.show')->with('message', '無法找到該商品或您無權更新它');
        }
    }

    public function updateAll(Request $request)
    {
        // 取得所有商品的 ID、價格和數量
        $productIds = $request->input('product_id');
        $prices = $request->input('price');
        $quantities = $request->input('quantity');

        // 檢查是否有資料
        if (!$productIds || !is_array($productIds)) {
            return redirect()->route('cart.show')->with('error', '無效的數據');
        }

        foreach ($productIds as $index => $productId) {
            $updated = SessionCart::where('product_id', $productId)
                ->where('user_id', Auth::id())
                ->update([
                    'price' => $prices[$index] ?? 0,  // 取出對應 index 的價格
                    'quantity' => $quantities[$index] ?? 1, // 取出對應 index 的數量
                ]);

            if (!$updated) {
                return redirect()->route('cart.show')->with('message', "商品 ID {$productId} 更新失敗");
            }
        }

        return redirect()->route('cart.show')->with('message', '詢價車商品已成功更新');
    }

    //送出詢價
    public function sendOrder(Request $request)
    {
        // 取得當前登入的使用者 Email
        $email = Auth::user()->email;
    
        // 取得所有 user_type = 'admin' 的 Email，轉換成陣列
        $adminEmails = User::where('user_type', 'admin')->pluck('email')->toArray();
    
        // 生成 order_id，使用當前日期時間
        $order_id = Carbon::now()->format('YmdHis'); // 例如：20250324123045
    
        // 獲取機構與收件人資訊
        $sales_name = $request->input('sales_name');
        $mailing_method = $request->input('mailing_method');
        $shipping = $request->input('shipping');
        $mechanism = $request->input('mechanism');
        $mechanism_recipient = $request->input('mechanism_recipient');
        $mechanism_recipient_phone = $request->input('mechanism_recipient_phone');
        $mechanism_recipient_address = $request->input('mechanism_recipient_address');
        $technical_name = $request->input('technical_name');
        $technical_address = $request->input('technical_address');
        $technical_phone = $request->input('technical_phone');
        $patient = $request->input('patient');
        $doctor = $request->input('doctor');
        $shipping_mode = $request->input('shipping_mode');
        $remark = $request->input('remark');
        $shipping_location = $request->input('shipping_location');
        $bill = $request->input('bill');
        $residential_address = $request->input('residential_address');
        $mechanism_doctor = $request->input('mechanism_doctor');
        $technical_contact_person = $request->input('technical_contact_person');
        $series_category_logo = $request->input('series_category_logo');
        $product_categories_logo = $request->input('product_categories_logo');
        $system_category_logo = $request->input('system_category_logo');



         // 用來儲存所有訂單項目
        $orderItems = [];
    
        // 檢查是否有產品資料
        if ($request->has('product_id') && is_array($request->input('product_id'))) {
            foreach ($request->input('product_id') as $index => $product_id) {
                // 建立新訂單
                $order = new Order();
                $order->user_id = Auth::id();
                $order->order_id = $order_id; // 儲存 order_id
                $order->brand_category = $request->input('brand_category')[$index];
                $order->brand_category_logo = $request->input('brand_category_logo')[$index];
                $order->series_category = $request->input('series_category')[$index];
                $order->product_categories = $request->input('product_categories')[$index];
                $order->system_category = $request->input('system_category')[$index];
                $order->product_id = $request->input('product_id')[$index];
                $order->product_name = $request->input('product_name')[$index];
                $order->price = $request->input('price')[$index];
                $order->diameter = $request->input('diameter')[$index];
                $order->length = $request->input('length')[$index];
                $order->high = $request->input('high')[$index];
                $order->cuff = $request->input('cuff')[$index];
                $order->angle = $request->input('angle')[$index];
                $order->type = $request->input('type')[$index];
                $order->post_h = $request->input('post_h')[$index];
                $order->thirdCategory = $request->input('thirdCategory')[$index];
                $order->image = $request->input('image')[$index];
                $order->quantity = $request->input('quantity')[$index];
                $order->series_category_logo = $request->input('series_category_logo')[$index];
                $order->product_categories_logo = $request->input('product_categories_logo')[$index];
                $order->system_category_logo = $request->input('system_category_logo')[$index];


                // 儲存收件人資訊
                $order->sales_name = $sales_name;
                $order->mailing_method = $mailing_method;
                $order->shipping = $shipping;
                $order->mechanism = $mechanism;
                $order->mechanism_recipient = $mechanism_recipient;
                $order->mechanism_recipient_phone = $mechanism_recipient_phone;
                $order->mechanism_recipient_address = $mechanism_recipient_address;
                $order->technical_name = $technical_name;
                $order->technical_address = $technical_address;
                $order->technical_phone = $technical_phone;
                $order->patient = $patient;
                $order->doctor = $doctor;
                $order->shipping_mode = $shipping_mode;
                $order->remark = $remark;
                $order->shipping_location = $shipping_location;
                $order->bill = $bill;
                $order->residential_address = $residential_address;
                $order->mechanism_doctor = $mechanism_doctor;
                $order->technical_contact_person = $technical_contact_person;

    
                // 儲存訂單
                $order->save();

                // 收集此訂單項目資料
                $orderItems[] = $order;
              
            }
        }

          // 發送郵件
          Mail::to($email)
          ->cc($adminEmails) // 副本
          ->send(new OrderMail($orderItems, $order_id));
    
        // 清空當前用戶的購物車
        SessionCart::where('user_id', Auth::id())->delete();
    
        // 返回成功訊息
        return redirect()->route('cart.show')->with('message', '詢價單已送出！');
    }

}
