<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Product;

class SeriesCategoryController extends Controller
{
    public function showbackup ($brand_category, $series_category)
    {
        // 取得該類別->系列類別->產品類別且不重複
        $products = Product::where('brand_category', $brand_category)
                            ->where('series_category', $series_category)
                            ->select('product_categories')->distinct()->get();

        // 如果沒有產品類別，則返回 404 頁面
        if ($products->isEmpty()) {
            abort(404, '找不到您選擇的產品類別');
        }

        return view('series_category.show', compact('brand_category', 'series_category','products'));
    }

    public function show ($brand_category, $series_category)
    {
        // 取得該類別->系列類別->產品類別且不重複
        $allProducts = Product::where('brand_category', $brand_category)
                            ->where('series_category', $series_category)->get();

        $products = $allProducts->groupBy('product_categories')->map(function ($items) {
            return $items->first(); // 每組只取第一筆
        })->values(); // 轉回索引陣列

        // 如果沒有產品類別，則返回 404 頁面
        if ($products->isEmpty()) {
            abort(404, '找不到您選擇的產品類別');
        }

        return view('series_category.show', compact('brand_category', 'series_category','products'));
    }

    
}
