<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Product;

class ProductCategoriesController extends Controller
{
    public function showbackup($brand_category, $series_category, $product_categories)
    {
        $products =  Product::where('brand_category', $brand_category)
                    ->where('series_category', $series_category)
                    ->where('product_categories', $product_categories)->get();


        // 如果沒有產品類別，則返回 404 頁面
        if ($products->isEmpty()) {
            abort(404, '找不到您選擇的產品類別');
        }

        return view('product_categories.show', compact('brand_category', 'series_category', 'product_categories','products'));
    }

    public function show($brand_category, $series_category, $product_categories)
    {
        //1. 確認product_categories、system_category是否一樣
        $products = Product::where('brand_category', $brand_category)
                            ->where('series_category', $series_category)
                            ->where('product_categories', $product_categories)
                            ->select('system_category') // 加上 select 以避免撈全部欄位
                            ->distinct()
                            ->get();

        if ($products->isEmpty()) {
            abort(404, '找不到您選擇的產品類別');
        }

        // 判斷唯一 system_category
        $uniqueSystemCategories = $products->pluck('system_category')->unique();

        if ($uniqueSystemCategories->count() === 1) {
            $systemCategory = $uniqueSystemCategories->first();

            return redirect()->route('system_category.show', [
                'brand_category' => $brand_category,
                'series_category' => $series_category,
                'product_categories' => $product_categories,
                'system_category' => $systemCategory,
            ]);
        }

        // 2. 撈出完整產品清單來顯示
        $products = Product::where('brand_category', $brand_category)
        ->where('series_category', $series_category)
        ->where('product_categories', $product_categories)
        ->get();

        return view('product_categories.show', compact(
            'brand_category',
            'series_category',
            'product_categories',
            'products'
        ));
    }

    
}
