<?php

namespace App\Http\Controllers;
use App\Models\Order;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class OrderController extends Controller
{
    public function show()
    {
        // 取得該廠商最新的50筆
        $orderItems = Order::where('user_id', Auth::id())
        ->orderBy('created_at', 'desc')
        ->limit(50)
        ->get();

        // 回傳詢價車畫面
        return view('order.show', compact('orderItems'));
    }

    public function search(Request $request)
    {
        // 取得使用者輸入的開始日期和結束日期
        $startDate = $request->input('start_date');
        $endDate = $request->input('end_date');

        // 查詢訂單
        $query = Order::query();

        if ($startDate) {
            $query->whereDate('created_at', '>=', $startDate);
        }
        if ($endDate) {
            $query->whereDate('created_at', '<=', $endDate);
        }

        // 取得結果
        $orderItems = $query->orderBy('created_at', 'desc')->get();

        return view('order.show', compact('orderItems'));
    }

    public function detail($order_id)
    {
        // 取得該訂單資料
        $orderItems = Order::where('user_id', Auth::id())
                    ->where('order_id', $order_id)->get();

        // 顯示該訂單細節
        return view('order.detail', compact('orderItems', 'order_id'));
    }
}
