<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Product;

class BrandCategoryController extends Controller
{
    public function showbackup($brand_category)
    {
        // 取得該類別的所有系列類別且不重複
        $products = Product::where('brand_category', $brand_category)
                            ->select('series_category')->distinct()->get();
        


        // 如果沒有產品，則返回 404 頁面
        if ($products->isEmpty()) {
            abort(404, '找不到該系列類別');
        }

        return view('brand_category.show', compact('brand_category', 'products'));
    }

    public function show($brand_category)
{
    // 撈出該 brand_category 下的所有產品
    $allProducts = Product::where('brand_category', $brand_category)->get();

    // 依照 series_category 分組，每個系列只取一筆產品資料
    $products = $allProducts->groupBy('series_category')->map(function ($items) {
        return $items->first(); // 每組只取第一筆
    })->values(); // 轉回索引陣列

    // 如果沒有產品，則返回 404 頁面
    if ($products->isEmpty()) {
        abort(404, '找不到該系列類別');
    }

    return view('brand_category.show', compact('brand_category', 'products'));
}

}
