<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;//因入登入user

use App\Models\Product;

class AdminController extends Controller
{
    public function index()
    {
        if(Auth::id())
        {
            $user_type = Auth()->user()->user_type;

            if($user_type == 'user')
            {
                return view('dashboard');
            }

            else if($user_type == 'admin')
            {
                return view('admin.index');
            }
            else if($user_type == 'sales')
            {
                // 取得不重複的品牌類別
                //$products = Product::select('brand_category')->distinct()->get();
                $products = Product::all();

                return view('sales.index', compact('products'));
            }
            else
            {
                return redirect()->back();
            }
        }
        
        // 如果使用者未登入，重導到登入頁面
        return redirect()->route('login')->with('error', '請先登入');
    }

    public function profileShow()
    {
        if(Auth::id())
        {
            $usertype = Auth()->user()->user_type;

            if($usertype == 'user')
            {
                return view('profile.show');
            }

            else if($usertype == 'admin')
            {
                return view('admin.profile.show');
            }
            else if($usertype == 'sales')
            {
                return view('sales.profile.show');
            }
            else
            {
                return redirect()->back();
            }
        }
        // 如果使用者未登入，重導到登入頁面
        return redirect()->route('login')->with('error', '請先登入');
    }
}
