<?php

namespace App\Actions\Fortify;

use App\Models\User;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Laravel\Fortify\Contracts\CreatesNewUsers;
use Laravel\Jetstream\Jetstream;

class CreateNewUser implements CreatesNewUsers
{
    use PasswordValidationRules;

    /**
     * Validate and create a newly registered user.
     *
     * @param  array<string, string>  $input
     */
    public function create(array $input): User
    {
        Validator::make($input, [
            'lastname' => ['required', 'string', 'max:255'],
            'firstname' => ['required', 'string', 'max:255'],
            'email' => ['required', 'string', 'email', 'max:255', 'unique:users'],
            'password' => $this->passwordRules(),
            'terms' => Jetstream::hasTermsAndPrivacyPolicyFeature() ? ['accepted', 'required'] : '',
        ])->validate();

        return User::create([
            'last_name' => $input['lastname'],
            'first_name' => $input['firstname'],
            'email' => $input['email'],
            'password' => Hash::make($input['password']),
            'mechanism' => $input['mechanism'],
            'mechanism_doctor' => $input['mechanism_doctor'],
            'mechanism_recipient' => $input['mechanism_recipient'],
            'mechanism_recipient_phone' => $input['mechanism_recipient_phone'],
            'phone' => $input['phone'],
            'mechanism_recipient_address' => $input['mechanism_recipient_address'],
            'sales_name' => $input['sales_name'],
            'technical_name' => $input['technical_name'],
            'technical_contact_person' => $input['technical_contact_person'],
            'technical_phone' => $input['technical_phone'],
            'technical_address' => $input['technical_address'],
        ]);
    }
}
