<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $__env->yieldContent('title'); ?></title>
    <link rel="icon" href="<?php echo e(asset('images/FVE_Logo.svg')); ?>" />
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=noto-sans:100,100i,200,200i,300,300i,400,400i,500,500i,600,600i,700,700i,800,800i,900,900i" rel="stylesheet" />
    <script src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js" defer></script>

</head>
<body class=" bg-sky-50 font-noto">
    <!--導覽列-->
    <nav class="sticky top-0 left-0 w-full bg-sky-50">
        <div class="px-4">
            <div class="flex items-center h-16 justify-between">      
                <div class="flex items-center">
                    <!--側邊欄-->
                    <div x-data="{ open: false }">
                        <!-- 按钮 -->
                        <button @click="open = true" class="focus:outline-none md:hidden px-4">
                            <img src="<?php echo e(asset('images/menu.png')); ?>" alt="menu" class="w-[25px]">
                        </button>
                        <!-- 遮罩层 -->
                        <div x-show="open" 
                            @click="open = false" 
                            class="fixed inset-0 bg-gray-800 bg-opacity-50 transition-opacity"
                            x-transition.opacity>
                        </div>

                        <!-- 侧边栏 -->
                        <aside x-show="open" 
                            x-transition:enter="transition transform duration-300"
                            x-transition:enter-start="-translate-x-full"
                            x-transition:enter-end="translate-x-0"
                            x-transition:leave="transition transform duration-300"
                            x-transition:leave-start="translate-x-0"
                            x-transition:leave-end="-translate-x-full"
                            class="fixed top-0 left-0 w-64 h-full bg-gray-700 shadow-md p-5 text-white">
                            <!-- 關閉按钮 -->
                            <button @click="open = false" class="text-white hover:text-gray-300 hover-bg-gray-400">
                                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="size-6">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M6 18 18 6M6 6l12 12" />
                                </svg>
                            </button>

                            <!-- 菜单项 -->
                            <nav class="mt-4">
                                <a href="/" class="block p-2 hover:text-gray-300">Home</a>
                                <a href="/products" class="block p-2 hover:text-gray-300">Products</a>
                            </nav>
                        </aside>
                    </div>
                    <!--logo-->
                    <a href="/">
                        <img src="<?php echo e(asset('images/FVE_Logo.png')); ?>" class="bg-left w-32" alt="FVE_Logo">
                    </a>
                </div>
                <div class="flex items-center">
                    <!-- 左侧的导航（只在 md 及以上显示） -->
                    <div class="hidden md:flex space-x-4">
                        <a href="/" class="hover:text-green-900">Home</a>
                        <a href="/products" class="hover:text-green-900">Products</a>
                    </div>
                    
                    <!-- 右侧的搜索按钮（始终显示） -->
                    <div x-data="{ open: false, search: '', items: [
                            { 
                                title: 'About us', content: 'Fine Vision Electronics engineers advanced microscope systems...', 
                                link:'/',
                                keywords:['about us']
                            },
                            { 
                                title: 'Fine Vision', 
                                content: 'Fine Vision Electronics engineers advanced microscope systems...', 
                                link:'/',
                                keywords:['fine vision']
                            },
                            { 
                                title: 'Products', content: 'Innovation and excellence in cosmetology, dentistry, and industry.', 
                                link:'/products',
                                keywords: ['Hair Transplant Machine', 'Viewer', 'Color Video Microscope', 'Dental Power Module', 'LED Dental Curing Light', 'Bioscope', 'Micro Viewer', 'Stand',
                                    'hair transplant machine', 'viewer', 'color video microscope', 'dental power module', 'led dental curing light', 'bioscope', 'micro viewer', 'stand'
                                ]
                            },
                        ] }">
                        
                        <!-- 開啟搜尋框按鈕 右侧的搜索按钮（始终显示） -->
                        <button @click="open = true" class="focus:outline-none px-4">
                            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="size-6 stroke-[2]">
                            <path stroke-linecap="round" stroke-linejoin="round" d="m21 21-5.197-5.197m0 0A7.5 7.5 0 1 0 5.196 5.196a7.5 7.5 0 0 0 10.607 10.607Z" />
                            </svg>
                        </button>

                        <!-- 遮罩 -->
                        <div x-show="open" class="fixed inset-0 bg-black bg-opacity-50" @click="open = false"></div>

                        <!-- 搜尋框彈出視窗 -->
                        <div x-show="open" class="fixed top-1/4 left-1/2 transform -translate-x-1/2 w-96 bg-white p-5 rounded-lg shadow-lg">
                            <h2 class="text-lg font-bold mb-2">Search</h2>

                            <!-- 搜尋輸入框 -->
                            <input 
                                type="text" 
                                x-model="search" 
                                placeholder="Search..."
                                class="w-full p-2 border rounded-lg focus:outline-none focus:ring focus:ring-blue-300"
                            >

                            <!-- 搜尋結果列表 -->
                            <ul class="mt-3 max-h-40 overflow-y-auto border-t">
                            <template x-for="item in items.filter(i => 
                                    i.title.includes(search) || 
                                    i.content.includes(search) || 
                                    i.link.includes(search) || 
                                    i.keywords.some(k => k.includes(search))
                                )" :key="item.title">
                                    <a :href="item.link">
                                        <li class="p-2 hover:bg-gray-200 cursor-pointer">
                                            <h3 class="font-bold" x-text="item.title"></h3>
                                            <p class="text-gray-600" x-text="item.content"></p>
                                        </li>
                                    </a>   
                                </template>
                            </ul>

                            <!-- ⚠️ 如果沒有符合的結果 -->
                            <p x-show="!items.filter(i => 
                                    i.title.includes(search) || 
                                    i.content.includes(search) || 
                                    i.keywords.some(k => k.includes(search))
                                ).length" class="text-gray-500 mt-4">
                                ❌ No results
                            </p>

                            <!-- 關閉按鈕 -->
                            <button @click="open = false" class="mt-4 w-full px-4 py-2 bg-green-900 text-white rounded-lg">
                                Close
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </nav>
    <!--中間內容-->
    <main>
        <?php echo $__env->yieldContent('main'); ?>
    </main>
    <!--頁尾-->
    <footer class="bg-gray-700 px-8 mt-[100px]">
        <div class="flex flex-col items-center">
            <!-- 主要內容區塊 -->
            <div class="grid grid-cols-1 md:grid-cols-2 md:gap-[150px] mt-2 max-w-max w-full">
                <!-- 左侧信息 -->
                <div class="text-[18px] leading-[2.5] text-white pt-6 md:text-left">
                    原華電子股份有限公司 <br>
                    Fine Vision Electronics Co., Ltd. <br>
                    新北市三重區興德路123之8號11樓 <br>
                    11F., No. 123-8, Xingde Rd., Sanchong Dist., New Taipei City, Taiwan <br>
                    TEL: 02-85123668 <br>
                    GUI number: 16215148 <br>
                </div>
                <!-- 右侧信息 -->
                <div class="text-[18px] leading-[2.5] text-white md:pt-6 pt-[50px] md:text-left">
                    FAQs <br>
                    Payment <br>
                    Cookie Policy <br>
                    Privacy Policy <br>
                    Terms & Conditions <br>
                </div>
            </div>

            <!-- 版权信息 -->
            <div class="text-[18px] leading-[2.5] text-white md:pt-6 pt-[50px] pb-6 text-center w-full">
                © 2025 FVE. All rights reserved.
            </div>
        </div>
        <?php echo $__env->yieldContent('footer'); ?>
    </footer>
</body>
</html><?php /**PATH /Users/fve_macbookpro/Desktop/fve-web/resources/views//layouts/application.blade.php ENDPATH**/ ?>