<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $__env->yieldContent('title'); ?></title>
    <link rel="icon" href="<?php echo e(asset('fve-web/public/images/FVE_Logo.svg')); ?>" />
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=noto-sans:100,100i,200,200i,300,300i,400,400i,500,500i,600,600i,700,700i,800,800i,900,900i" rel="stylesheet" />
    <script src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js" defer></script>
    
    <!--網站預設連結圖片-->
    <meta property="og:title" content="FVE">
    <meta property="og:description" content="Fine Vision Electronics engineers advanced microscope systems, cutting-edge illumination products,...">
    <meta property="og:image" content="https://ilandtower.com/fve-web/public/images/FVE_Company.png">
    <meta property="og:url" content="https://ilandtower.com/">
    <meta property="og:type" content="website">
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:image" content="https://ilandtower.com/fve-web/public/images/FVE_Company.png">
    
    <!-- Twitter Card Meta Tags -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="FVE">
    <meta name="twitter:description" content="Fine Vision Electronics engineers advanced microscope systems, cutting-edge illumination products,...">
    <meta name="twitter:image" content="https://ilandtower.com/fve-web/public/images/FVE_Company.png">

</head>
<body class=" bg-sky-50 font-noto">
    <!--導覽列-->
    <nav class="sticky top-0 left-0 w-full bg-sky-50 md:p-8 py-4">
        <div class="px-4 max-w-screen-2xl mx-auto">
            <div class="flex items-center md:h-16 h-[25px] justify-between">  
                <div class="flex items-center">
                    <!--側邊欄-->
                    <div x-data="{ open: false }">
                        <!-- 按钮 -->
                        <button @click="open = true" class="focus:outline-none md:hidden px-2">
                            <svg class="w-6 h-6 text-gray-700" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="none" viewBox="0 0 24 24">
                                  <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M18 6H6m12 4H6m12 4H6m12 4H6"/>
                            </svg>
                        </button>
                        <!-- 遮罩层 -->
                        <div x-show="open" 
                            @click="open = false" 
                            class="fixed inset-0 bg-gray-800 bg-opacity-50 transition-opacity"
                            x-transition.opacity>
                        </div>

                        <!-- 侧边栏 -->
                        <aside x-show="open" 
                            x-transition:enter="transition transform duration-300"
                            x-transition:enter-start="-translate-x-full"
                            x-transition:enter-end="translate-x-0"
                            x-transition:leave="transition transform duration-300"
                            x-transition:leave-start="translate-x-0"
                            x-transition:leave-end="-translate-x-full"
                            class="fixed top-0 left-0 w-64 h-full bg-gray-700 shadow-md p-5 text-white">
                            <!-- 關閉按钮 -->
                            <button @click="open = false" class="text-white hover:text-gray-300 hover-bg-gray-400">
                                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="size-6">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M6 18 18 6M6 6l12 12" />
                                </svg>
                            </button>

                            <!-- 菜单项 -->
                            <nav class="mt-4">
                                <a href="/" class="block p-2 hover:text-gray-300">Home</a>
                                <a href="/products" class="block p-2 hover:text-gray-300">Products</a>
                            </nav>
                        </aside>
                    </div>
                    <!--logo-->
                    <a href="/">
                        <img src="<?php echo e(asset('fve-web/public/images/FVE_Logo.png')); ?>" class="md:bg-left md:w-32 w-[50px] hidden md:block" alt="FVE_Logo">
                    </a>
                </div>
                <div class="flex items-center">
                    <!--手機logo-->
                    <a href="/">
                        <img src="<?php echo e(asset('fve-web/public/images/FVE_Logo.png')); ?>" class="md:bg-center w-[70px] md:hidden" alt="FVE_Logo">
                    </a>
                </div>
                <div class="flex items-center">
                    <!-- 左侧的導航（只在 md 及以上显示） -->
                    <div class="hidden md:flex space-x-4">
                        <a href="/" class="hover:text-green-900">Home</a>
                        <a href="/products" class="hover:text-green-900">Products</a>
                    </div>
                </div>
            </div>
        </div>
    </nav>
    <!--中間內容-->
    <main>
        <?php echo $__env->yieldContent('main'); ?>
    </main>
    <!--頁尾-->
    <footer class="bg-gray-700 px-8 mt-[100px]">
        <div class="flex flex-col max-w-screen-lg mx-auto">
            <!-- 主要內容區塊 -->
            <div class="grid grid-cols-1 md:grid-cols-5 md:gap-[150px] mt-2 ">
                <!-- 左侧信息 -->
                <div class="text-[18px] leading-[3] text-white pt-6 md:text-left col-span-3">
                    原華電子股份有限公司 <br>
                    Fine Vision Electronics Co., Ltd. <br>
                    新北市三重區興德路123之8號11樓 <br>
                    11F., No. 123-8, Xingde Rd., Sanchong Dist., New Taipei City, Taiwan <br>
                    TEL: 02-85123668 <br>
                    GUI number: 16215148 <br>
                </div>
                <!-- 右侧信息 -->
                <div class="text-[18px] leading-[3] text-white md:pt-6 pt-[50px] md:text-left col-span-2">
                    FAQs <br>
                    Payment <br>
                    Cookie Policy <br>
                    Privacy Policy <br>
                    Terms & Conditions <br>
                </div>
            </div>

            <!-- 版权信息 -->
            <div class="text-[18px] leading-[2.5] text-white md:pt-6 mt-[50px] pb-6 text-center w-full">
                © 2025 FVE. All rights reserved.
            </div>
        </div>
        <?php echo $__env->yieldContent('footer'); ?>
    </footer>
</body>
</html><?php /**PATH /home/ilandtower/public_html/fve-web/resources/views//layouts/application.blade.php ENDPATH**/ ?>