@extends('/layouts/application')

@section('title', 'Home')

@section('main')
<div class="md:px-[60px] 2xl:px-[150px] xl:px-[100px] px-[25px] max-w-screen-2xl mx-auto">
    <!--公司簡介-->
    <p class="text-[36px] font-semibold text-green-900 md:mt-[100px] mt-[200px] px-4">Company</p>
    <div class="grid grid-cols-1 md:grid-cols-2">
        <div class="px-4">
            <p class="text-[18px] leading-[2.5] mb-8 mt-6">
            Fine Vision Electronics engineers advanced microscope systems, cutting-edge illumination products, and high-intensity LED curing lights. With over 30 years of expertise, we push the boundaries of design and manufacturing. Backed by extensive research and innovation, our high-performance solutions are engineered for precision, reliability, and efficiency. 
            </p>
        </div>
        <div class="mt-8 place-items-center">
            <img src="{{ asset('fve-web/public/images/FVE_Company.png') }}" alt="FVE_Company" class="w-full max-w-[600px]">
        </div>
    </div>
    <!--公司業務內容-->
    <div class="grid grid-cols-1 mt-[200px] md:h-auto">
        <p class="text-[36px] font-semibold text-green-900 md:h-auto h-[400px]">
            Innovation and excellence in cosmetology, dentistry, and industry.
        </p>
    </div>
    <div class="grid grid-cols-1 gap-6 md:grid-cols-3 mt-[100px] md:px-2 px-2 snap-x snap-mandatory">
        <div class="md:mb-2 md:h-auto h-[700px]">
            <img src="{{ asset('fve-web/public/images/FVE_Cosmetology.png') }}" alt="FVE_Cosmetology" class="w-full max-w-96">
            <p class="text-[36px] font-semibold text-green-900 mt-4">
                Cosmetology
            </p>
           <ul class="list-disc px-5 text-[18px] leading-[2.5]">
                <li>Hair Transplant Machine</li>
                <li>Viewer</li>
           </ul>
        </div>
        <div class="md:mb-2 md:h-auto h-[700px]">
            <img src="{{ asset('fve-web/public/images/FVE_Dentistry.png') }}" alt="FVE_Dentistry" class="w-full max-w-96">
            <p class="text-[36px] font-semibold text-green-900 mt-4">
                Dentistry
            </p>
            <ul class="list-disc px-5 text-[18px] leading-[2.5]">
                <li>Color Video Microscope</li>
                <li>Dental Power Module</li>
                <li>Dental Unit Control System</li>
                <li>LED Dental Curing Light</li>
                <li>Universal Piezo Driver Module</li>
           </ul>
        </div>
        <div class="md:mb-2 md:h-auto h-[700px]">
            <img src="{{ asset('fve-web/public/images/FVE_Industry.png') }}" alt="FVE_Industry.png" class="w-full max-w-96">
            <p class="text-[36px] font-semibold text-green-900 mt-4">
                Industry
            </p>
            <ul class="list-disc px-5 text-[18px] leading-[2.5]">
                <li>Bioscope</li>
                <li>Micro Viewer</li>
                <li>Stand</li>
           </ul>
        </div>
    </div>
    <!--公司合作夥伴-->
    <div class="grid grid-cols-1 mt-[200px]">
        <p class="text-[36px] font-semibold text-green-900">
            Our partners
        </p>
        <p class="text-[18px] leading-[2.5]">From A to Z</p>
    </div>
    <div class="grid grid-cols-3 gap-x-6 gap-y-[100px] md:grid-cols-6 mt-[100px] text-center">
        <div>
            <img src="{{ asset('fve-web/public/images/partners/AIRISU.png') }}" alt="Airisu Tech" class="w-full max-w-48">
            <p class="list-disc mt-6 text-center text-[18px] leading-[1.5]">
                Airisu Tech
            </p>
        </div>
        <div>
            <img src="{{ asset('fve-web/public/images/partners/Amway_Hong_Kong.png') }}" alt="Amway Hong Kong" class="w-full max-w-48">
            <p class="list-disc mt-6 text-center text-[18px] leading-[1.5]">
                Amway Hong Kong
            </p>
        </div>
        <div>
            <img src="{{ asset('fve-web/public/images/partners/AVON.png') }}" alt="AVON" class="w-full max-w-48">
            <p class="list-disc mt-6 text-center text-[18px] leading-[1.5]">
                AVON
            </p>
        </div>
        <div>
            <img src="{{ asset('fve-web/public/images/partners/Estee_Lauder.png') }}" alt="Estée Lauder" class="w-full max-w-48">
            <p class="list-disc mt-6 text-center text-[18px] leading-[1.5]">
                Estée Lauder
            </p>
        </div>
        <div>
            <img src="{{ asset('fve-web/public/images/partners/Iris_Kenkou.png') }}" alt="Iris Kenkou" class="w-full max-w-48">
            <p class="list-disc mt-6 text-center text-[18px] leading-[1.5]">
                Iris Kenkou
            </p>
        </div>
        <div>
            <img src="{{ asset('fve-web/public/images/partners/JOURDENESS.png') }}" alt="JOURDENESS" class="w-full max-w-48">
            <p class="list-disc mt-6 text-center text-[18px] leading-[1.5]">
                JOURDENESS
            </p>
        </div>
        <div>
            <img src="{{ asset('fve-web/public/images/partners/National_Taiwan_University.png') }}" alt="National Taiwan University" class="w-full max-w-48">
            <p class="list-disc mt-6 text-center text-[18px] leading-[1.5]">
                National Taiwan University
            </p>
        </div>
        <div>
            <img src="{{ asset('fve-web/public/images/partners/Shinwa_Clinic.png') }}" alt="Shinwa Clinic" class="w-full max-w-48">
            <p class="list-disc mt-6 text-center text-[18px] leading-[1.5]">
                Shinwa Clinic
            </p>
        </div>
        <div>
            <img src="{{ asset('fve-web/public/images/partners/SKII.png') }}" alt="SK-II" class="w-full max-w-48">
            <p class="list-disc mt-6 text-center text-[18px] leading-[1.5]">
                SK-II
            </p>
        </div>
        <div>
            <img src="{{ asset('fve-web/public/images/partners/Takara_Belmont_Taiwan.png') }}" alt="Takara Belmont Taiwan" class="w-full max-w-48">
            <p class="list-disc mt-6 text-center text-[18px] leading-[1.5]">
                Takara Belmont Taiwan
            </p>
        </div>
        <div>
            <img src="{{ asset('fve-web/public/images/partners/Tsinghua_University.png') }}" alt="Tsinghua University" class="w-full max-w-48">
            <p class="list-disc mt-6 text-center text-[18px] leading-[1.5]">
                Tsinghua University
            </p>
        </div>
    </div>
</div>    
@endsection